
-- SQL TO CREATE A REDCAP DEMO PROJECT --
set @project_title = 'Project Tracking Database';


-- Obtain default values --
set @institution = (select value from redcap_config where field_name = 'institution' limit 1);
set @site_org_type = (select value from redcap_config where field_name = 'site_org_type' limit 1);
set @grant_cite = (select value from redcap_config where field_name = 'grant_cite' limit 1);
set @project_contact_name = (select value from redcap_config where field_name = 'project_contact_name' limit 1);
set @project_contact_email = (select value from redcap_config where field_name = 'project_contact_email' limit 1);
set @headerlogo = (select value from redcap_config where field_name = 'headerlogo' limit 1);
set @auth_meth = (select value from redcap_config where field_name = 'auth_meth_global' limit 1);
-- Create project --
INSERT INTO `redcap_projects`
(project_name, app_title, status, count_project, auth_meth, creation_time, production_time, institution, site_org_type, grant_cite, project_contact_name, project_contact_email, headerlogo, display_project_logo_institution, auto_inc_set) VALUES
(concat('redcap_demo_',LEFT(sha1(rand()),6)), @project_title, 1, 0, @auth_meth, now(), now(), @institution, @site_org_type, @grant_cite, @project_contact_name, @project_contact_email, @headerlogo, 0, 1);
set @project_id = LAST_INSERT_ID();
-- Create single arm --
INSERT INTO redcap_events_arms (project_id, arm_num, arm_name) VALUES (@project_id, 1, 'Arm 1');
set @arm_id = LAST_INSERT_ID();
-- Create single event --
INSERT INTO redcap_events_metadata (arm_id, day_offset, offset_min, offset_max, descrip) VALUES (@arm_id, 0, 0, 0, 'Event 1');
set @event_id = LAST_INSERT_ID();
-- Insert into redcap_metadata --
INSERT INTO redcap_metadata (project_id, field_name, field_phi, form_name, form_menu_description, field_order, field_units, element_preceding_header, element_type, element_label, element_enum, element_note, element_validation_type, element_validation_min, element_validation_max, element_validation_checktype, branching_logic, field_req, edoc_id, edoc_display_img, custom_alignment, stop_actions, question_num, grid_name, misc) VALUES
(@project_id, 'proj_id', NULL, 'project', 'Project', 1, NULL, NULL, 'text', 'Project ID', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'title', NULL, 'project', NULL, 2, NULL, 'Demographic Characteristics', 'textarea', 'Project Title', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'pi_firstname', NULL, 'project', NULL, 3, NULL, NULL, 'text', 'PI First Name', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'pi_lastname', NULL, 'project', NULL, 4, NULL, NULL, 'text', 'PI Last Name', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'pi_vunetid', NULL, 'project', NULL, 5, NULL, NULL, 'text', 'PI VUnetID', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'project_type', NULL, 'project', NULL, 6, NULL, NULL, 'select', 'Project Type', '1, Expedited \\n 2, Full Committee \\n 3, Industry only', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'irb_number', NULL, 'project', NULL, 7, NULL, NULL, 'text', 'IRB Number', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'amendment_status', NULL, 'project', NULL, 8, NULL, 'Amendment Information', 'radio', 'Amendment?', '0, No \\n 1, Yes', '', NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'amendment_number', NULL, 'project', NULL, 9, NULL, NULL, 'select', 'Amendment Number', '0 \\n 1 \\n 2 \\n 3 \\n 4 \\n 5 \\n 6 \\n 7 \\n 8 \\n 9 \\n 10 \\n 11 \\n 12 \\n 13 \\n 14 \\n 15 \\n 16 \\n 17 \\n 18 \\n 19 \\n 20', '', NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'crc_type', NULL, 'project', NULL, 10, NULL, 'CRC Legacy System Data', 'select', 'CRC Type', 'A \\n B \\n C \\n D', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'crc_webcamp_import', NULL, 'project', NULL, 11, NULL, NULL, 'select', 'CRC WebCamp Project Import?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'crc_original_review', NULL, 'project', NULL, 12, NULL, NULL, 'select', 'CRC Original Review?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'file_proposal', NULL, 'project', NULL, 13, NULL, 'Project Files', 'file', 'Research Proposal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'file_budget', NULL, 'project', NULL, 14, NULL, NULL, 'file', 'Budget', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'file_biosketch1', NULL, 'project', NULL, 15, NULL, NULL, 'file', 'Biosketch(1)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'file_biosketch2', NULL, 'project', NULL, 16, NULL, NULL, 'file', 'Biosketch(2)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'file_biosketch3', NULL, 'project', NULL, 17, NULL, NULL, 'file', 'Biosketch(3)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'file_crc', NULL, 'project', NULL, 18, NULL, NULL, 'file', 'CRC Resources', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'file_other1', NULL, 'project', NULL, 19, NULL, NULL, 'file', 'Other(1)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'file_other2', NULL, 'project', NULL, 20, NULL, NULL, 'file', 'Other(2)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'file_other3', NULL, 'project', NULL, 21, NULL, NULL, 'file', 'Other(3)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'project_complete', NULL, 'project', NULL, 22, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'date_receipt', NULL, 'workflow', 'Workflow', 23, NULL, 'Pre-Pre-Review Information', 'text', 'Project Receipt Date', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'date_start_preprereview', NULL, 'workflow', NULL, 24, NULL, NULL, 'text', 'Pre-Pre-Review - Start Date', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'date_stop_preprereview', NULL, 'workflow', NULL, 25, NULL, NULL, 'text', 'Pre-Pre-Review - Stop Date', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'comments_preprereview', NULL, 'workflow', NULL, 26, NULL, NULL, 'textarea', 'Comments - Pre-Pre-Review', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'owner_prepreview', NULL, 'workflow', NULL, 27, NULL, NULL, 'select', 'Owner (Liaison)', '0, Shraddha \\n 1, Jennifer \\n 2, Terri \\n 3, Cheryl \\n 4, Lynda', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'date_start_prereview', NULL, 'workflow', NULL, 28, NULL, 'Pre-Review Information', 'text', 'Pre-Review Notification Date', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'date_stop_prereview', NULL, 'workflow', NULL, 29, NULL, NULL, 'text', 'Pre-Review Completion Date', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'comments_prereview', NULL, 'workflow', NULL, 30, NULL, NULL, 'textarea', 'Comments - Pre-Review', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'date_pi_notification', NULL, 'workflow', NULL, 31, NULL, 'PI Notification Information', 'text', 'PI Notification Date', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'date_pi_response', NULL, 'workflow', NULL, 32, NULL, NULL, 'text', 'PI Response Date', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'comments_pi_response', NULL, 'workflow', NULL, 33, NULL, NULL, 'textarea', 'Comments - PI Process', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'file_pi_comments', NULL, 'workflow', NULL, 34, NULL, NULL, 'file', 'PI response', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'date_agenda', NULL, 'workflow', NULL, 35, NULL, 'Agenda Information', 'text', 'Agenda Date', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'rev1_name', NULL, 'workflow', NULL, 36, NULL, NULL, 'text', 'Reviewer 1', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'rev2_name', NULL, 'workflow', NULL, 37, NULL, NULL, 'text', 'Reviewer 2', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'rev_notification_date', NULL, 'workflow', NULL, 38, NULL, NULL, 'text', 'Date - Sent to Reviewers', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'src_notification_date', NULL, 'workflow', NULL, 39, NULL, NULL, 'text', 'Date- Sent to SRC', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'status_src_award', NULL, 'workflow', NULL, 40, NULL, NULL, 'select', 'SRC Award Status', '0, Approved \\n 1, Pending \\n 2, Deferred (Studio) \\n 3, Disapproved \\n 4, Tabled \\n 5, Withdrawn', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'src_priority_score', NULL, 'workflow', NULL, 41, NULL, NULL, 'text', 'SRC Priority Score', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'workflow_complete', NULL, 'workflow', NULL, 42, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'needs_administrative', NULL, 'prereview_administrative', 'Pre-Review Administrative', 43, NULL, NULL, 'select', 'Requires Administrative?', '0, Yes \\n 1, No', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_administrative', NULL, 'prereview_administrative', NULL, 44, NULL, 'Enter PI Pre-Review Notes Or Attach File', 'textarea', 'Notes', NULL, NULL, NULL, NULL, NULL, NULL, '[needs_administrative] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_administrative_doc', NULL, 'prereview_administrative', NULL, 45, NULL, NULL, 'file', 'OR File<br><font size=1>(NOTE: If file will not open, then Save it to your computer and then Open it.)</font>', NULL, NULL, NULL, NULL, NULL, NULL, '[needs_administrative] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_administrative_date_sent', NULL, 'prereview_administrative', NULL, 46, NULL, NULL, 'text', 'Date Sent for pre-review', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_administrative_date_received', NULL, 'prereview_administrative', NULL, 47, NULL, NULL, 'text', 'Date received', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_administrative_complete', NULL, 'prereview_administrative', NULL, 48, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'needs_biostatistics', NULL, 'prereview_biostatistics', 'Pre-Review Biostatistics', 49, NULL, NULL, 'select', 'Requires Biostatistics?', '0, Yes \\n 1, No', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_biostatistics', NULL, 'prereview_biostatistics', NULL, 50, NULL, 'Enter Pre-Review Notes Or Attach File', 'textarea', 'PI Suggestions', NULL, NULL, NULL, NULL, NULL, NULL, '[needs_biostatistics] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_biostatistics_doc', NULL, 'prereview_biostatistics', NULL, 51, NULL, NULL, 'file', 'OR File<br><font size=1>(NOTE: If file will not open, then Save it to your computer and then Open it.)</font>', NULL, NULL, NULL, NULL, NULL, NULL, '[needs_biostatistics] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_biostatistics_date_sent', NULL, 'prereview_biostatistics', NULL, 52, NULL, NULL, 'text', 'Date Sent for pre-review', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_biostatistics_date_received', NULL, 'prereview_biostatistics', NULL, 53, NULL, NULL, 'text', 'Date received', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_biostatistics_hours_awarded', NULL, 'prereview_biostatistics', NULL, 54, NULL, 'Biostatistics Award', 'text', 'Consultation Hours Awarded', NULL, NULL, 'float', '0', '5000', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_biostatistics_complete', NULL, 'prereview_biostatistics', NULL, 55, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'needs_scientific', NULL, 'prereview_scientific', 'Pre-Review Scientific', 56, NULL, NULL, 'select', 'Requires Scientific?', '0, Yes \\n 1, No', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_scientific', NULL, 'prereview_scientific', NULL, 57, NULL, 'Enter Pre-Review Notes Or Attach File', 'textarea', 'PI Suggestions', NULL, NULL, NULL, NULL, NULL, NULL, '[needs_scientific] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_scientific_doc', NULL, 'prereview_scientific', NULL, 58, NULL, NULL, 'file', 'OR File<br><font size=1>(NOTE: If file will not open, then Save it to your computer and then Open it.)</font>', NULL, NULL, NULL, NULL, NULL, NULL, '[needs_scientific] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_scientific_date_sent', NULL, 'prereview_scientific', NULL, 59, NULL, NULL, 'text', 'Date Sent for pre-review', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_scientific_date_received', NULL, 'prereview_scientific', NULL, 60, NULL, NULL, 'text', 'Date received', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_scientific_complete', NULL, 'prereview_scientific', NULL, 61, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'needs_participant', NULL, 'prereview_participant', 'Pre-Review Participant', 62, NULL, NULL, 'select', 'Requires Participant?', '0, Yes \\n 1, No', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_participant', NULL, 'prereview_participant', NULL, 63, NULL, 'Enter Pre-Review Notes Or Attach File', 'textarea', 'PI Suggestions', NULL, NULL, NULL, NULL, NULL, NULL, '[needs_participant] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_participant_doc', NULL, 'prereview_participant', NULL, 64, NULL, NULL, 'file', 'OR File<br><font size=1>(NOTE: If file will not open, then Save it to your computer and then Open it.)</font>', NULL, NULL, NULL, NULL, NULL, NULL, '[needs_participant] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_participant_date_sent', NULL, 'prereview_participant', NULL, 65, NULL, NULL, 'text', 'Date Sent for pre-review', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_participant_date_received', NULL, 'prereview_participant', NULL, 66, NULL, NULL, 'text', 'Date received', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_participant_complete', NULL, 'prereview_participant', NULL, 67, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'needs_budget', NULL, 'prereview_budget', 'Pre-Review Budget', 68, NULL, NULL, 'select', 'Requires Budget?', '0, Yes \\n 1, No', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_budget', NULL, 'prereview_budget', NULL, 69, NULL, 'Enter Pre-Review Notes Or Attach File', 'textarea', 'PI Suggestions', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_budget_doc', NULL, 'prereview_budget', NULL, 70, NULL, NULL, 'file', 'OR File<br><font size=1>(NOTE: If file will not open, then Save it to your computer and then Open it.)</font>', NULL, NULL, NULL, NULL, NULL, NULL, '[needs_budget] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_budget_date_sent', NULL, 'prereview_budget', NULL, 71, NULL, NULL, 'text', 'Date Sent for pre-review', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', '[needs_budget] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_budget_date_received', NULL, 'prereview_budget', NULL, 72, NULL, NULL, 'text', 'Date received', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_budget_complete', NULL, 'prereview_budget', NULL, 73, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'needs_nursing', NULL, 'prereview_nursing', 'Pre-Review Nursing', 74, NULL, NULL, 'select', 'Requires Nursing?', '0, Yes \\n 1, No', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_nursing', NULL, 'prereview_nursing', NULL, 75, NULL, 'Enter Pre-Review Notes Or Attach File', 'textarea', 'PI Suggestions', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_nursing_doc', NULL, 'prereview_nursing', NULL, 76, NULL, NULL, 'file', 'OR File<br><font size=1>(NOTE: If file will not open, then Save it to your computer and then Open it.)</font>', NULL, NULL, NULL, NULL, NULL, NULL, '[needs_nursing] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_nursing_date_sent', NULL, 'prereview_nursing', NULL, 77, NULL, NULL, 'text', 'Date Sent for pre-review', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', '[needs_nursing] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_nursing_date_received', NULL, 'prereview_nursing', NULL, 78, NULL, NULL, 'text', 'Date received', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_nursing_complete', NULL, 'prereview_nursing', NULL, 79, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'needs_cores', NULL, 'prereview_cores', 'Pre-Review Cores', 80, NULL, NULL, 'select', 'Requires Cores?', '0, Yes \\n 1, No', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_cores', NULL, 'prereview_cores', NULL, 81, NULL, 'Enter Pre-Review Notes Or Attach File', 'textarea', 'PI Suggestions', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_cores_doc', NULL, 'prereview_cores', NULL, 82, NULL, NULL, 'file', 'OR File<br><font size=1>(NOTE: If file will not open, then Save it to your computer and then Open it.)</font>', NULL, NULL, NULL, NULL, NULL, NULL, '[needs_cores] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_cores_date_sent', NULL, 'prereview_cores', NULL, 83, NULL, NULL, 'text', 'Date Sent for pre-review', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', '[needs_cores] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_cores_date_received', NULL, 'prereview_cores', NULL, 84, NULL, NULL, 'text', 'Date received', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_cores_complete', NULL, 'prereview_cores', NULL, 85, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'needs_sleep', NULL, 'prereview_sleep', 'Pre-Review Sleep', 86, NULL, NULL, 'select', 'Requires Sleep?', '0, Yes \\n 1, No', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_sleep', NULL, 'prereview_sleep', NULL, 87, NULL, 'Enter Pre-Review Notes Or Attach File', 'textarea', 'PI Suggestions', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_sleep_doc', NULL, 'prereview_sleep', NULL, 88, NULL, NULL, 'file', 'OR File<br><font size=1>(NOTE: If file will not open, then Save it to your computer and then Open it.)</font>', NULL, NULL, NULL, NULL, NULL, NULL, '[needs_sleep] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_sleep_date_sent', NULL, 'prereview_sleep', NULL, 89, NULL, NULL, 'text', 'Date Sent for pre-review', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', '[needs_sleep] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_sleep_date_received', NULL, 'prereview_sleep', NULL, 90, NULL, NULL, 'text', 'Date received', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_sleep_complete', NULL, 'prereview_sleep', NULL, 91, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'needs_nutrition', NULL, 'prereview_nutrition', 'Pre-Review Nutrition', 92, NULL, NULL, 'select', 'Requires Nutrition?', '0, Yes \\n 1, No', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_nutrition', NULL, 'prereview_nutrition', NULL, 93, NULL, 'Enter Pre-Review Notes Or Attach File', 'textarea', 'PI Suggestions', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_nutrition_doc', NULL, 'prereview_nutrition', NULL, 94, NULL, NULL, 'file', 'OR File<br><font size=1>(NOTE: If file will not open, then Save it to your computer and then Open it.)</font>', NULL, NULL, NULL, NULL, NULL, NULL, '[needs_nutrition] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_nutrition_date_sent', NULL, 'prereview_nutrition', NULL, 95, NULL, NULL, 'text', 'Date Sent for pre-review', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', '[needs_nutrition] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_nutrition_date_received', NULL, 'prereview_nutrition', NULL, 96, NULL, NULL, 'text', 'Date received', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_nutrition_complete', NULL, 'prereview_nutrition', NULL, 97, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'needs_community', NULL, 'prereview_community', 'Pre-Review Community', 98, NULL, NULL, 'select', 'Requires Community?', '0, Yes \\n 1, No', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_community', NULL, 'prereview_community', NULL, 99, NULL, 'Enter Pre-Review Notes Or Attach File', 'textarea', 'PI Suggestions', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_community_doc', NULL, 'prereview_community', NULL, 100, NULL, NULL, 'file', 'OR File<br><font size=1>(NOTE: If file will not open, then Save it to your computer and then Open it.)</font>', NULL, NULL, NULL, NULL, NULL, NULL, '[needs_community] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_community_date_sent', NULL, 'prereview_community', NULL, 101, NULL, NULL, 'text', 'Date Sent for pre-review', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', '[needs_community] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_community_date_received', NULL, 'prereview_community', NULL, 102, NULL, NULL, 'text', 'Date received', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_community_complete', NULL, 'prereview_community', NULL, 103, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'needs_other', NULL, 'prereview_ctc', 'Pre-Review CTC', 104, NULL, NULL, 'select', 'Requires Other?', '0, Yes \\n 1, No', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_other', NULL, 'prereview_ctc', NULL, 105, NULL, 'Enter Pre-Review Notes Or Attach File', 'textarea', 'PI Suggestions', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_other_doc', NULL, 'prereview_ctc', NULL, 106, NULL, NULL, 'file', 'OR File<br><font size=1>(NOTE: If file will not open, then Save it to your computer and then Open it.)</font>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_other_date_sent', NULL, 'prereview_ctc', NULL, 107, NULL, NULL, 'text', 'Date Sent for pre-review', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_other_date_received', NULL, 'prereview_ctc', NULL, 108, NULL, NULL, 'text', 'Date received', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_ctc_complete', NULL, 'prereview_ctc', NULL, 109, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'needs_pi_response', NULL, 'prereview_pi_response', 'Pre-Review PI Response', 110, NULL, NULL, 'select', 'Requires PI Response?', '0, Yes \\n 1, No', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_pi_response', NULL, 'prereview_pi_response', NULL, 111, NULL, 'Enter Pre-Review Notes Or Attach File', 'textarea', 'PI response', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_pi_response_doc', NULL, 'prereview_pi_response', NULL, 112, NULL, NULL, 'file', 'OR File<br><font size=1>(NOTE: If file will not open, then Save it to your computer and then Open it.)</font>', NULL, NULL, NULL, NULL, NULL, NULL, '[needs_pi_response] = "0"', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_pi_response_date_sent', NULL, 'prereview_pi_response', NULL, 113, NULL, NULL, 'text', 'Date Sent for pre-review', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_pi_response_date_received', NULL, 'prereview_pi_response', NULL, 114, NULL, NULL, 'text', 'Date received', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'prereview_pi_response_complete', NULL, 'prereview_pi_response', NULL, 115, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'src_percent_funded', NULL, 'post_award_administration', 'Post-Award Administration', 116, NULL, 'Post-Award Administration', 'text', 'Percent of request funded (%)', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'src_total_award_amount', NULL, 'post_award_administration', NULL, 117, NULL, NULL, 'text', 'SRC Total Award Amount ($)', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'src_letter_date', NULL, 'post_award_administration', NULL, 118, NULL, NULL, 'text', 'SRC letter sent', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'src_letter_document', NULL, 'post_award_administration', NULL, 119, NULL, NULL, 'file', 'SRC letter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'src_project_ending', NULL, 'post_award_administration', NULL, 120, NULL, NULL, 'text', 'SRC project ending date', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'src_full_project_period', NULL, 'post_award_administration', NULL, 121, NULL, NULL, 'text', 'SRC full project period', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'src_center_number', NULL, 'post_award_administration', NULL, 122, NULL, NULL, 'text', 'SRC Center Number - Institutional', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'src_center_number_ctsa', NULL, 'post_award_administration', NULL, 123, NULL, NULL, 'text', 'SRC Center Number - CTSA', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'src_center_number_crc', NULL, 'post_award_administration', NULL, 124, NULL, NULL, 'text', 'SRC Center Number - CRC', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'src_center_number_dh', NULL, 'post_award_administration', NULL, 125, NULL, NULL, 'text', 'D & H Number', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'comments_src', NULL, 'post_award_administration', NULL, 126, NULL, NULL, 'textarea', 'Comments - SRC Award', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'crc_facilities', NULL, 'post_award_administration', NULL, 127, NULL, NULL, 'text', 'CRC Facilities ($)', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'crc_personnel', NULL, 'post_award_administration', NULL, 128, NULL, NULL, 'text', 'CRC Nursing ($)', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'crc_cores', NULL, 'post_award_administration', NULL, 129, NULL, NULL, 'text', 'CRC Cores ($)', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'sleep_cores', NULL, 'post_award_administration', NULL, 130, NULL, NULL, 'text', 'Sleep Core ($)', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'vumc_core_facilities', NULL, 'post_award_administration', NULL, 131, NULL, NULL, 'text', 'VUMC Core Facilities ($)', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'personnel', NULL, 'post_award_administration', NULL, 132, NULL, NULL, 'text', 'Personnel ($)', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'equipment', NULL, 'post_award_administration', NULL, 133, NULL, NULL, 'text', 'Equipment ($)', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'misc_services', NULL, 'post_award_administration', NULL, 134, NULL, NULL, 'text', 'Misc. Services ($)', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'hospital_ancillaries', NULL, 'post_award_administration', NULL, 135, NULL, NULL, 'text', 'Hospital Ancillaries ($)', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'victr_status', NULL, 'post_award_administration', NULL, 136, NULL, NULL, 'radio', 'VICTR Status', '0, Inactive \\n 1, Active', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'src_project_completion', NULL, 'post_award_administration', NULL, 137, NULL, NULL, 'text', 'SRC completion date', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'post_award_administration_complete', NULL, 'post_award_administration', NULL, 138, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL);

INSERT INTO `redcap_projects_templates` (`project_id`, `title`, `description`, `enabled`)
	VALUES (@project_id,  @project_title,  'Fifteen data entry forms dedicated to recording the attributes of and tracking and progress of projects/studies.',  '1');