
-- SQL TO CREATE A REDCAP DEMO PROJECT --
set @project_title = 'Human Cancer Tissue Biobank';


-- Obtain default values --
set @institution = (select value from redcap_config where field_name = 'institution' limit 1);
set @site_org_type = (select value from redcap_config where field_name = 'site_org_type' limit 1);
set @grant_cite = (select value from redcap_config where field_name = 'grant_cite' limit 1);
set @project_contact_name = (select value from redcap_config where field_name = 'project_contact_name' limit 1);
set @project_contact_email = (select value from redcap_config where field_name = 'project_contact_email' limit 1);
set @headerlogo = (select value from redcap_config where field_name = 'headerlogo' limit 1);
set @auth_meth = (select value from redcap_config where field_name = 'auth_meth_global' limit 1);
-- Create project --
INSERT INTO `redcap_projects`
(project_name, app_title, status, count_project, auth_meth, creation_time, production_time, institution, site_org_type, grant_cite, project_contact_name, project_contact_email, headerlogo, display_project_logo_institution, randomization, auto_inc_set) VALUES
(concat('redcap_demo_',LEFT(sha1(rand()),6)), @project_title, 1, 0, @auth_meth, now(), now(), @institution, @site_org_type, @grant_cite, @project_contact_name, @project_contact_email, @headerlogo, 0, 0, 1);
set @project_id = LAST_INSERT_ID();
-- Create single arm --
INSERT INTO redcap_events_arms (project_id, arm_num, arm_name) VALUES (@project_id, 1, 'Arm 1');
set @arm_id = LAST_INSERT_ID();
-- Create single event --
INSERT INTO redcap_events_metadata (arm_id, day_offset, offset_min, offset_max, descrip) VALUES (@arm_id, 0, 0, 0, 'Event 1');
set @event_id = LAST_INSERT_ID();
-- Insert into redcap_metadata --
INSERT INTO redcap_metadata (project_id, field_name, field_phi, form_name, form_menu_description, field_order, field_units, element_preceding_header, element_type, element_label, element_enum, element_note, element_validation_type, element_validation_min, element_validation_max, element_validation_checktype, branching_logic, field_req, edoc_id, edoc_display_img, custom_alignment, stop_actions, question_num, grid_name, misc) VALUES
(@project_id, 'lab_id', '0', 'id_shipping', 'ID Shipping', 1, NULL, 'IDs', 'text', 'Lab ID', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'trc_id', NULL, 'id_shipping', NULL, 2, NULL, NULL, 'text', 'TRC ID', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'first_name', '1', 'id_shipping', NULL, 3, NULL, NULL, 'text', 'First Name', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'middle_name', NULL, 'id_shipping', NULL, 4, NULL, NULL, 'text', 'Middle Name', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'last_name', '1', 'id_shipping', NULL, 5, NULL, NULL, 'text', 'Last Name', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'suffix', NULL, 'id_shipping', NULL, 6, NULL, NULL, 'text', 'Suffix', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'date_of_birth', '1', 'id_shipping', NULL, 7, NULL, NULL, 'text', 'Date of Birth', NULL, NULL, 'date_mdy', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'age', NULL, 'id_shipping', NULL, 8, NULL, NULL, 'text', 'Age', NULL, 'Age at surgery, DOB not available', 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'facility_name', NULL, 'id_shipping', NULL, 9, NULL, 'Shipping Information', 'text', 'Facility_Name', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'facility_city', NULL, 'id_shipping', NULL, 10, NULL, NULL, 'text', 'Facility_City', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'facility_state', NULL, 'id_shipping', NULL, 11, NULL, NULL, 'text', 'Facility_State', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'receivedate', '1', 'id_shipping', NULL, 12, NULL, NULL, 'text', 'ReceiveDate', NULL, NULL, 'date_mdy', NULL, NULL, 'soft_typed', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'shipmethod', NULL, 'id_shipping', NULL, 13, NULL, NULL, 'select', 'ShipMethod', '1, FedEx \\n 2, USPS \\n 3, UPS \\n 4, ByPerson \\n 5, Others', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'trackingnumber', NULL, 'id_shipping', NULL, 14, NULL, NULL, 'text', 'ReceiveTracking', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'pathaccnumber', '1', 'id_shipping', NULL, 15, NULL, NULL, 'text', 'PathAccNumber', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'otheraccnumber2', NULL, 'id_shipping', NULL, 16, NULL, NULL, 'text', 'OtherAccNumber', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'blk_no_received', NULL, 'id_shipping', NULL, 17, NULL, NULL, 'text', 'Block_ Received', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'stainedslide_received', NULL, 'id_shipping', NULL, 18, NULL, NULL, 'text', 'StainedSlide_Received', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'unstainedslide_received', NULL, 'id_shipping', NULL, 19, NULL, NULL, 'text', 'UnstainedSlide_Received', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'return_needed', NULL, 'id_shipping', NULL, 20, NULL, NULL, 'yesno', 'Return_Needed?', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'return_date', NULL, 'id_shipping', NULL, 21, NULL, NULL, 'text', 'ReturnDate', NULL, NULL, 'date_mdy', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'return_tracking', NULL, 'id_shipping', NULL, 22, NULL, NULL, 'text', 'ReturnTracking', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'labcirculation_time', NULL, 'id_shipping', NULL, 23, NULL, NULL, 'calc', 'LabCirculation_time', 'round(datediff([receivedate],[return_date],"d","mdy"))', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'followup_note', NULL, 'id_shipping', NULL, 24, NULL, NULL, 'textarea', 'FollowUp_Note', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'secondtime_getsample', NULL, 'id_shipping', NULL, 25, NULL, 'If Receive Sample 2nd Time', 'yesno', '2nd_Time_Receive', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'follow_up_needed2', NULL, 'id_shipping', NULL, 26, NULL, NULL, 'yesno', 'Follow up needed?', NULL, NULL, NULL, NULL, NULL, NULL, '[secondtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'collection_note2', NULL, 'id_shipping', NULL, 27, NULL, NULL, 'textarea', 'FollowUp_Note2', NULL, NULL, NULL, NULL, NULL, NULL, '[follow_up_needed2] = ''1'' and [secondtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'samefacasbefore', NULL, 'id_shipping', NULL, 28, NULL, NULL, 'yesno', 'SameFacilityAsBefore?', NULL, NULL, NULL, NULL, NULL, NULL, '[secondtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'facility_name2', NULL, 'id_shipping', NULL, 29, NULL, NULL, 'text', 'Facility_Name2', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[samefacasbefore] = ''0'' and [secondtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'facility_city2', NULL, 'id_shipping', NULL, 30, NULL, NULL, 'text', 'Facility_City2', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[secondtime_getsample] = ''1'' and [samefacasbefore] = ''0''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'facility_state2', NULL, 'id_shipping', NULL, 31, NULL, NULL, 'text', 'Facility_State2', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[secondtime_getsample] = ''1'' and [samefacasbefore] = ''0''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'receivedate2', NULL, 'id_shipping', NULL, 32, NULL, NULL, 'text', 'ReceiveDate2', NULL, NULL, 'date_mdy', NULL, NULL, 'soft_typed', '[secondtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'shipmethod2', NULL, 'id_shipping', NULL, 33, NULL, NULL, 'select', 'ShipMethod2', '1, FedEx \\n 2, USPS \\n 3, UPS \\n 4, ByPerson \\n 5, Others', NULL, NULL, NULL, NULL, NULL, '[secondtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'receivetracking2', NULL, 'id_shipping', NULL, 34, NULL, NULL, 'text', 'ReceiveTracking2', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[secondtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'pathaccnumber2', NULL, 'id_shipping', NULL, 35, NULL, NULL, 'text', 'PathAccNumber', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[secondtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'otheraccnumber', NULL, 'id_shipping', NULL, 36, NULL, NULL, 'text', 'OtherAccNumber', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[secondtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'block_received2', NULL, 'id_shipping', NULL, 37, NULL, NULL, 'text', 'Block_ Received2', NULL, NULL, 'float', NULL, NULL, 'soft_typed', '[secondtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'stainedslide_received2', NULL, 'id_shipping', NULL, 38, NULL, NULL, 'text', 'StainedSlide_Received2', NULL, NULL, 'float', NULL, NULL, 'soft_typed', '[secondtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'unstainedslide_received2', NULL, 'id_shipping', NULL, 39, NULL, NULL, 'text', 'UnstainedSlide_Received2', NULL, NULL, 'float', NULL, NULL, 'soft_typed', '[secondtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'return_needed2', NULL, 'id_shipping', NULL, 40, NULL, NULL, 'yesno', 'Return_needed?', NULL, NULL, NULL, NULL, NULL, NULL, '[secondtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'returndate2', NULL, 'id_shipping', NULL, 41, NULL, NULL, 'text', 'ReturnDate2', NULL, NULL, 'date_mdy', NULL, NULL, 'soft_typed', '[return_needed2] = ''1'' and [secondtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'return_tracking2', NULL, 'id_shipping', NULL, 42, NULL, NULL, 'text', 'ReturnTracking2', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[return_needed2] = ''1'' and [secondtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'thirdtime_getsample', NULL, 'id_shipping', NULL, 43, NULL, 'If Receive Sample 3rd Time', 'yesno', '3rd_Time_Receive', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'follow_up_needed3', NULL, 'id_shipping', NULL, 44, NULL, NULL, 'yesno', 'Follow up needed?', NULL, NULL, NULL, NULL, NULL, NULL, '[thirdtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'collection_note3', NULL, 'id_shipping', NULL, 45, NULL, NULL, 'textarea', 'FollowUp_Note', NULL, NULL, NULL, NULL, NULL, NULL, '[follow_up_needed3] = ''1'' and [thirdtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'samefacilityasbefore2', NULL, 'id_shipping', NULL, 46, NULL, NULL, 'yesno', 'SameFacilityAsBefore?', NULL, NULL, NULL, NULL, NULL, NULL, '[thirdtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'facility_name3', NULL, 'id_shipping', NULL, 47, NULL, NULL, 'text', 'Facility_Name3', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[samefacilityasbefore2] = ''0'' and [thirdtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'facility_city3', NULL, 'id_shipping', NULL, 48, NULL, NULL, 'text', 'Facility_City3', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[samefacilityasbefore2] = ''0'' and [thirdtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'facility_state3', NULL, 'id_shipping', NULL, 49, NULL, NULL, 'text', 'Facility_State3', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[samefacilityasbefore2] = ''0'' and [thirdtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'receivedate3', NULL, 'id_shipping', NULL, 50, NULL, NULL, 'text', 'ReceiveDate3', NULL, NULL, 'date_mdy', NULL, NULL, 'soft_typed', '[thirdtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'shipmethod3', NULL, 'id_shipping', NULL, 51, NULL, NULL, 'select', 'ShipMethod3', '1, FedEx \\n 2, USPS \\n 3, UPS \\n 4, ByPerson \\n 5, Others', NULL, NULL, NULL, NULL, NULL, '[thirdtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'receivetracking3', NULL, 'id_shipping', NULL, 52, NULL, NULL, 'text', 'ReceiveTracking3', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[thirdtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'pathaccnumber3', NULL, 'id_shipping', NULL, 53, NULL, NULL, 'text', 'PathAccNumber3', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[thirdtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'otheraccnumber3', NULL, 'id_shipping', NULL, 54, NULL, NULL, 'text', 'OtherAccNumber', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[thirdtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'block_received3', NULL, 'id_shipping', NULL, 55, NULL, NULL, 'text', 'Block_ Received3', NULL, NULL, 'float', NULL, NULL, 'soft_typed', '[thirdtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'stainedslide_received3', NULL, 'id_shipping', NULL, 56, NULL, NULL, 'text', 'StainedSlide_Received3', NULL, NULL, 'float', NULL, NULL, 'soft_typed', '[thirdtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'unstainedslide_received3', NULL, 'id_shipping', NULL, 57, NULL, NULL, 'text', 'UnstainedSlide_Received3', NULL, NULL, 'float', NULL, NULL, 'soft_typed', '[thirdtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'return_needed3', NULL, 'id_shipping', NULL, 58, NULL, NULL, 'yesno', 'Return_needed?', NULL, NULL, NULL, NULL, NULL, NULL, '[thirdtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'returndate3', NULL, 'id_shipping', NULL, 59, NULL, NULL, 'text', 'ReturnDate3', NULL, NULL, 'date_mdy', NULL, NULL, 'soft_typed', '[return_needed3] = ''1'' and [thirdtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'returntracking3', NULL, 'id_shipping', NULL, 60, NULL, NULL, 'text', 'ReturnTracking3', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[return_needed3] = ''1'' and [thirdtime_getsample] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'id_shipping_complete', NULL, 'id_shipping', NULL, 61, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tumor_origin', NULL, 'pathology_review', 'Pathology Review', 62, NULL, 'Tumor Origin and Location', 'select', 'Tumor_Origin', '1, Breast \\n 2, Prostate \\n 3, Colorectum \\n 4, Lung \\n 5, Others', NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'specify_other_origin', NULL, 'pathology_review', NULL, 63, NULL, NULL, 'text', 'Specify_Other_Origin', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''5''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tumor_location', NULL, 'pathology_review', NULL, 64, NULL, NULL, 'select', 'Location_Breast_Prostate', '1, Left \\n 2, Right \\n 3, Bilateral \\n 4, Multiple \\n 5, Unclear', 'Multiple means 2 or more', NULL, NULL, NULL, NULL, '[tumor_origin] = ''1'' or [tumor_origin] = ''2''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tumor_location_colorectum', NULL, 'pathology_review', NULL, 65, NULL, NULL, 'select', 'Location_Colorectum', '1, Appendix \\n 2, Cecum \\n 3, Ascending \\n 4, Hepatic Flexure \\n 5, Transverse \\n 6, Splenic Flexure \\n 7, Descending \\n 8, Sigmoid \\n 9, Rectum \\n 10, Anus \\n 11, Left \\n 12, Right \\n 13, Unclear', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''3''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tumor_location_lung', NULL, 'pathology_review', NULL, 66, NULL, NULL, 'select', 'Location_Lung', '1, Right Upper Lobe \\n 2, Right Middle Lobe \\n 3, Right Lower Lobe \\n 4, Left Upper Lobe \\n 5, Left Lower Lobe \\n 6, Right Bronchus \\n 7, Left Bronchus \\n 8, Right \\n 9, Left \\n 10, Unclear \\n 11, Others (specify it)', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''4''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'other_location_lung', NULL, 'pathology_review', NULL, 67, NULL, NULL, 'text', 'Other location_lung', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''4'' and [tumor_location_lung] = ''11''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'specify_other_location', NULL, 'pathology_review', NULL, 68, NULL, NULL, 'text', 'Specify_Other_Location', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''5''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'date_surgery', NULL, 'pathology_review', NULL, 69, NULL, 'Clinical Pathology Information', 'text', 'Date_Surgery', NULL, NULL, 'date_mdy', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'age_at_surgery', NULL, 'pathology_review', NULL, 70, NULL, NULL, 'calc', 'Age at Surgery', 'round(datediff([date_of_birth],[date_surgery],"y","mdy",true),0)', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'sex', NULL, 'pathology_review', NULL, 71, NULL, NULL, 'select', 'sex', '0, Female \\n 1, Male \\n 2, Other \\n 3, Prefer not to say', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'pathol_acc_no', '1', 'pathology_review', NULL, 72, NULL, NULL, 'text', 'Pathol_Acc_No', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 1, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'other_acc_no', NULL, 'pathology_review', NULL, 73, NULL, NULL, 'text', 'Other_Acc_No', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'block_tumor', NULL, 'pathology_review', NULL, 74, NULL, NULL, 'text', 'BlockNum_Tumor', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'block_normal', NULL, 'pathology_review', NULL, 75, NULL, NULL, 'text', 'BlockNum_Normal', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'block_metastatic', NULL, 'pathology_review', NULL, 76, NULL, NULL, 'text', 'BlockNum_Metastatic', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'block_precancerous', NULL, 'pathology_review', NULL, 77, NULL, NULL, 'text', 'BlockNum_Precancerous', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'invitrosize1', NULL, 'pathology_review', NULL, 78, NULL, NULL, 'text', 'InvitroSize1', NULL, 'Maximum size in centimeter', 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'invitrosize2', NULL, 'pathology_review', NULL, 79, NULL, NULL, 'text', 'InvitroSize2', NULL, 'In % of total tissue volume for prostate cancer', 'float', NULL, NULL, 'soft_typed', '[tumor_origin] = ''2''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'invitrosize3', NULL, 'pathology_review', NULL, 80, NULL, NULL, 'text', 'InvitroSize3', NULL, 'The seceond largest tumor', NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'perineuralinvasion', NULL, 'pathology_review', NULL, 81, NULL, NULL, 'select', 'PerineuralInvasion', '0, No \\n 1, Yes \\n 2, N/A', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'vascular_invasion', NULL, 'pathology_review', NULL, 82, NULL, NULL, 'select', 'Vascular invasion present', '0, No \\n 1, Yes \\n 2, N/A', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'surgical_margin_cancer_pre', NULL, 'pathology_review', NULL, 83, NULL, NULL, 'select', 'Surgical margin cancer present', '0, No \\n 1, Yes \\n 2, N/A', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'clin_diagn_breast', NULL, 'pathology_review', NULL, 84, NULL, 'For Breast Cancer Samples', 'select', 'Clin_Diagn_Breast', '1, Noninvasive carcinoma (NOS) \\n 2, Ductal carcinoma in situ \\n 3, Lobular carcinoma in situ \\n 4, Paget disease without invasive carcinoma \\n 5, Invasive carcinoma (NOS) \\n 6, Invasive ductal carcinoma \\n 7, IDC with an extensive intraductal component \\n 8, IDC with Paget disease \\n 9, Invasive lobular \\n 10, Mucinous \\n 11, Medullary \\n 12, Papillary \\n 13, Tubular \\n 14, Adenoid cystic \\n 15, Secretory (juvenile) \\n 16, Apocrine \\n 17, Cribriform \\n 18, Carcinoma with squamous metaplasia \\n 19, Carcinoma with spindle cell metaplasia \\n 20, Carcinoma with cartilaginous/osseous metaplasia \\n 21, Carcinoma with metaplasia, mixed type \\n 22, Other(s) (specify) \\n 23, Not assessable \\n 24, No cancer tissue \\n 25, IDC+ILC (50 -90% each component)', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'lab_diagn_breast', NULL, 'pathology_review', NULL, 85, NULL, NULL, 'select', 'Lab_Diagn_Breast', '1, Noninvasive carcinoma (NOS) \\n 2, Ductal carcinoma in situ \\n 3, Lobular carcinoma in situ \\n 4, Paget disease without invasive carcinoma \\n 5, Invasive carcinoma (NOS) \\n 6, Invasive ductal carcinoma \\n 7, IDC with an extensive intraductal component \\n 8, IDC with Paget disease \\n 9, Invasive lobular \\n 10, Mucinous \\n 11, Medullary \\n 12, Papillary \\n 13, Tubular \\n 14, Adenoid cystic \\n 15, Secretory (juvenile) \\n 16, Apocrine \\n 17, Cribriform \\n 18, Carcinoma with squamous metaplasia \\n 19, Carcinoma with spindle cell metaplasia \\n 20, Carcinoma with cartilaginous/osseous metaplasia \\n 21, Carcinoma with metaplasia, mixed type \\n 22, Other(s) (specify) \\n 23, Not assessable \\n 24, No cancer tissue \\n 25, IDC+ILC (50 -90% each component)', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'if_ilc_subtype', NULL, 'pathology_review', NULL, 86, NULL, NULL, 'select', 'ILC_Subtype', '901, classical ILC \\n 902, solid ILC \\n 903, pleomorphic ILC \\n 904, alveolar ILC \\n 905, tubulolobular ILC \\n 906, mixed ILC \\n 907, signet ring cell ILC \\n 908, others', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''1'' and [lab_diagn_breast] = ''9''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'specify_if_other_type_br', NULL, 'pathology_review', NULL, 87, NULL, NULL, 'text', 'Specify_If_Other_Type_Br', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'clin_grade_breast', NULL, 'pathology_review', NULL, 88, NULL, NULL, 'select', 'Clin_Grade_Breast', '1, 1 \\n 2, 2 \\n 3, 3 \\n 4, 1~2 \\n 5, 2~3 \\n 6, N/A', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'lab_grade_breast', NULL, 'pathology_review', NULL, 89, NULL, NULL, 'select', 'Lab_Grade_Breast', '1, 1 \\n 2, 2 \\n 3, 3 \\n 4, N/A', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'estrogen_receptor', NULL, 'pathology_review', NULL, 90, NULL, NULL, 'select', 'Estrogen Receptor', '0, negative \\n 1, week (<1%) \\n 2, positive (>=1%) \\n 3, N/A', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'progesterone_receptor', NULL, 'pathology_review', NULL, 91, NULL, NULL, 'select', 'Progesterone Receptor', '0, negative (0~2) \\n 1, week (3~4) \\n 2, intermediate (5~6) \\n 3, strong (7~8) \\n 4, N/A', 'Allred Score System 0-8', NULL, NULL, NULL, NULL, '[tumor_origin] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'her2_immunohistochemistry', NULL, 'pathology_review', NULL, 92, NULL, NULL, 'select', 'HER2_Immunohistochemistry', '0, 0 \\n 1, 1 (1~9% cells positivity) \\n 2, 2 (10-30% cells positivity) \\n 3, 3 (>30% cells positivity with strong color) \\n 4, N/A', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'her2_fish', NULL, 'pathology_review', NULL, 93, NULL, NULL, 'select', 'HER2_FISH', '0, 0 (Non-Amplified, <1.8) \\n 1, 1 (Amplified, >2.2) \\n 2, 2 (Borderline, 1.8~2.2) \\n 3, N/A', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'bc_molecularsubtype', NULL, 'pathology_review', NULL, 94, NULL, NULL, 'select', 'BC_MolecularSubtype', '1, Luminal A \\n 2, Luminal B \\n 3, HER2 \\n 4, Triple Negative \\n 5, N/A', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'ki_67', NULL, 'pathology_review', NULL, 95, NULL, NULL, 'text', 'Ki-67', NULL, 'positive cells in percentage', 'float', NULL, NULL, 'soft_typed', '[tumor_origin] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'p53_ihc', NULL, 'pathology_review', NULL, 96, NULL, NULL, 'text', 'p53_IHC', NULL, 'positive cells in percentage', NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'dna_index', NULL, 'pathology_review', NULL, 97, NULL, NULL, 'text', 'DNA Index', NULL, 'Unfavorable: >1.1', NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'bc_precancerous', NULL, 'pathology_review', NULL, 98, NULL, NULL, 'select', 'BC_Precancerous', '1, Not seen \\n 2, DCIS \\n 3, LCIS \\n 4, DCIS+LCIS', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tnm_breast_tumor', NULL, 'pathology_review', NULL, 99, NULL, NULL, 'select', 'TNMbreast_PrimTum(T)', '1, TX:Primary tumor cannot be assessed \\n 2, T0:No evidence of primary tumor \\n 3, Tis:DCIS/LCIS/Paget''s dis w/o associated tumor \\n 4, T1mic:Microinvasion <=0.1 cm \\n 5, T1a:>0.1 but <=0.5 cm \\n 6, T1b:>0.5 cm but <=1.0 cm \\n 7, T1c:>1.0 cm but <=2.0 cm \\n 8, T2:Tumor >2.0 cm but <=5.0 cm \\n 9, T3:Tumor >5.0 cm \\n 10, T4a:Any size with direct extension to chest wall \\n 11, T4b:skin Edema/ulceration;satellite skin nodules \\n 12, T4c:Both of T4a and T4b \\n 13, T4d:Inflammatory carcinoma', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tnmbreast_ln_n', NULL, 'pathology_review', NULL, 100, NULL, NULL, 'select', 'TNMbreast_LN (N)', '1, NX: Regional LNs cannot be assessed \\n 2, N0: No regional LNs metastasis \\n 3, N1: Movable ipsilateral axillary LN(s) \\n 4, N2: Ipsilateral axillary LN(s) fixed \\n 5, N3: Ipsilateral internal mammary LN(s) \\n 6, pNX: Regional LNs cannot be assessed \\n 7, pN0: No regional LNs metastasis \\n 8, pN1: movable ipsilateral axillary LN(s) \\n 9, pN1a:Only micrometastasis <=0.2 cm \\n 10, pN1b: Metastasis any >0.2 cm \\n 11, pN1bi:1 to 3 LNs, any >0.2 cm and all <2.0 cm \\n 12, pN1bii: >=4 LN3, any >0.2 cm and all <2.0 cm \\n 13, pN1biii: beyond LN capsule,metastasis <2.0 cm \\n 14, pN1biv: Metastasis to a LN >=2.0 cm \\n 15, pN2: to ipsilateral axillaryLN(s) fixed \\n 16, pN3: to ipsilateral internal mammary LN(s) \\n 17, pN0(i+)', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tnmbreast_distantmetast_m', NULL, 'pathology_review', NULL, 101, NULL, NULL, 'select', 'TNMbreast_DistantMetast (M)', '1, MX: cannot be assessed \\n 2, M0: No distant metastasis \\n 3, M1: yes includes ipsilateral supraclavicular LNs', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'clin_diagn_prostate', NULL, 'pathology_review', NULL, 102, NULL, 'For Prostate Cancer Samples', 'select', 'Clin_Diagn_Prostate', '1, Adenocarcinoma,NOS \\n 2, Prostatic duct adenocarcinoma \\n 3, Mucinous adenocarcinoma \\n 4, Signet-ring cell carcinoma \\n 5, Adenosquemous carcinoma \\n 6, Small cell carcinoma \\n 7, Sarcomatoid carcinoma \\n 8, Other (specifiy) \\n 9, Undifferentiated carcinoma, NOS \\n 10, Cannot be determined', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''2''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'lab_diag_prostate', NULL, 'pathology_review', NULL, 103, NULL, NULL, 'select', 'Lab_Diag_Prostate', '1, Adenocarcinoma,NOS \\n 2, Prostatic duct adenocarcinoma \\n 3, Mucinous adenocarcinoma \\n 4, Signet-ring cell carcinoma \\n 5, Adenosquemous carcinoma \\n 6, Small cell carcinoma \\n 7, Sarcomatoid carcinoma \\n 8, Other (specifiy) \\n 9, Undifferentiated carcinoma, NOS \\n 10, Cannot be determined', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''2''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'specify_if_other_type_pro', NULL, 'pathology_review', NULL, 104, NULL, NULL, 'text', 'Specify_If_Other_type_Pro', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''2''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'clin_gleason_score', NULL, 'pathology_review', NULL, 105, NULL, NULL, 'text', 'Clin_Gleason_Score', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''2''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'clin_grade_pro', NULL, 'pathology_review', NULL, 106, NULL, NULL, 'select', 'Clin_Grade_Pro', '1, Low(1-4) \\n 2, Intermediate(5-7) \\n 3, High(8-10)', 'Gleason Score System', NULL, NULL, NULL, NULL, '[tumor_origin] = ''2''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'lab_gleason_score', NULL, 'pathology_review', NULL, 107, NULL, NULL, 'text', 'Lab_Gleason_Score', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''2''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'lab_grade_pro', NULL, 'pathology_review', NULL, 108, NULL, NULL, 'select', 'Lab_Grade_Pro', '1, Low(1-4) \\n 2, Intermediate(5-7) \\n 3, High(8-10)', 'Gleason Score System (1-10)', NULL, NULL, NULL, NULL, '[tumor_origin] = ''2''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tnmprostate_t', NULL, 'pathology_review', NULL, 109, NULL, NULL, 'select', 'TNMprostate_T', '1, T1: Microscopic, DRE/Ultrasound undetectable \\n 2, T1a: <=5 percent \\n 3, T1b: >5 percent \\n 4, T1c: as F/U of screening w/ high PSA \\n 5, T2: within prost, DRE/ultrasound detectable \\n 6, T2a: >half of one lobe \\n 7, T2b: >half of one lobe,DRE detectable often \\n 8, T2c: involve both lobes \\n 9, T3: surrounding tissues or seminal vesicles \\n 10, T3a: outside prostate on one side \\n 11, T3b: outside prostate on both sides \\n 12, T3c: to one or both seminal tubes \\n 13, T4a: to bladder or rectum \\n 14, T4b: beyond prostate or levator muscles \\n 15, TX', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''2''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tnmprostate_n', NULL, 'pathology_review', NULL, 110, NULL, NULL, 'select', 'TNMprostate_N', '1, N0: not to pelvic LN \\n 2, N1: a single pelvic LN,<= 2 cm \\n 3, N2: a single pelvic LN,2-5cm \\n 4, N3: >5 cm in size \\n 5, NX', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''2''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tnmprostate_m', NULL, 'pathology_review', NULL, 111, NULL, NULL, 'select', 'TNMprostate_M', '1, M0: spread only regionally in pelvic area \\n 2, M1: spread beyond pelvic area \\n 3, MX', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''2''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'psa_level', NULL, 'pathology_review', NULL, 112, NULL, NULL, 'text', 'PSA_Level', NULL, 'ng/mL', NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''2''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'seminalinvasion', NULL, 'pathology_review', NULL, 113, NULL, NULL, 'select', 'SeminalInvasion', '0, No \\n 1, Yes \\n 2, N/A', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''2''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'extraprostate_extention', NULL, 'pathology_review', NULL, 114, NULL, NULL, 'select', 'ExtraProstate Extention', '0, No \\n 1, Yes \\n 2, N/A', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''2''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'clin_giag_colon', NULL, 'pathology_review', NULL, 115, NULL, 'For Colon Cancer Samples', 'select', 'Clin_Diagn_Colon', '1, 1 Adenocarcinoma \\n 2, 2 Mucinous adenocarcinoma \\n 3, 3 Medullary carcinoma \\n 4, 4 Signet ring cell carcinoma \\n 5, 5 Small cell carcinoma \\n 6, 6 Squamous cell carcinoma \\n 7, 7 Adenosquamous carcinoma \\n 8, 8 Others \\n 9, 9 Adenoma', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''3''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'specify_colon_clin', NULL, 'pathology_review', NULL, 116, NULL, NULL, 'text', 'If others_specify', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''3'' and [clin_giag_colon] = ''8''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'lab_diagn_colon', NULL, 'pathology_review', NULL, 117, NULL, NULL, 'select', 'Lab_Diagn_Colon', '1, 1 Adenocarcinoma \\n 2, 2 Mucinous adenocarcinoma \\n 3, 3 Medullary carcinoma \\n 4, 4 Signet ring cell carcinoma \\n 5, 5 Small cell carcinoma \\n 6, 6 Squamous cell carcinoma \\n 7, 7 Adenosquamous carcinoma \\n 8, 8 Others \\n 9, 9 Adenoma', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''3''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'specify_colon_lab', NULL, 'pathology_review', NULL, 118, NULL, NULL, 'text', 'If others_specify', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''3'' and [lab_diagn_colon] = ''8''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'clin_grade_colon', NULL, 'pathology_review', NULL, 119, NULL, NULL, 'select', 'Clin_Grade_Colon', '1, Low \\n 2, Intermediate \\n 3, High \\n 4, N/A \\n 5, Low-Intermediate \\n 6, Intermediate-High', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''3''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'lab_grade_colon', NULL, 'pathology_review', NULL, 120, NULL, NULL, 'select', 'Lab_Grade_Colon', '1, Low \\n 2, Intermediate \\n 3, High \\n 4, N/A', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''3''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tnmcolon_t', NULL, 'pathology_review', NULL, 121, NULL, NULL, 'select', 'TNMcolon_T', 'Tx, Tx \\n Tis, Tis earliest stage (in situ) involves only mucosa \\n T1, T1 through the muscularis mucosa \\n T2, T2 through submucosa into muscularis propria \\n T3, T3 through muscularis propria into outermost layers \\n T4a, T4a through serosa/visceral peritoneum \\n T4b, T4b through the wall attach/invade nearby tissues', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''3''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tnmcolon_n', NULL, 'pathology_review', NULL, 122, NULL, NULL, 'select', 'TNMcolon_N', 'Nx, Nx incomplete information. \\n N0, N0 No cancer in nearby LNs \\n N1a, N1a in 1 nearby LN \\n N1b, N1b in 2 to 3 nearby LNs \\n N1c, N1c cancer cells in areas of fat near LN, but not in LNs \\n N2a, N2a in 4 to 6 nearby LN \\n N2b, N2b in 7 or more nearby LNs', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''3''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tnmcolon_m', NULL, 'pathology_review', NULL, 123, NULL, NULL, 'select', 'TNMcolon_M', 'M0, M0 No distant spread \\n M1a, M1a to 1 distant organ or set of distant LNs \\n M1b, M1b to >1 or distant parts peritoneum \\n MX, MX', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''3''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'pre_cancerous_colon', NULL, 'pathology_review', NULL, 124, NULL, NULL, 'textarea', 'Pre-cancerous_Colon', NULL, NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''3''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'clin_diagn_lung', NULL, 'pathology_review', NULL, 125, NULL, 'For Lung Cancer Samples', 'select', 'Clin_Diagn_Lung', '1, Squamous cell carcinoma 8070/3 \\n 2, Small cell carcinoma 8041/3 \\n 3, Adenocarcinoma 8140/3 \\n 4, Adenocarcinoma, mixed subtype 8255/3 \\n 5, Adenocarcinoma, Acinar 8550/3 \\n 6, Adenocarcinoma, Papillary 8260/3 \\n 7, Adenocarcinoma, Micropapillary \\n 8, Bronchioloalveolar carcinoma 8250/3 \\n 9, Solid adenocarcinoma with mucin 8230/3 \\n 10, Adenosquamous carcinoma 8560/3 \\n 11, Large cell carcinoma 8012/3 \\n 12, Sarcomatoid carcinoma 8033/3 \\n 13, Carcinoid tumour 8240/3 \\n 14, Mucoepidermoid carcinoma 8430/3 \\n 15, Epithelial-myoepithelial carcinoma 8562/3 \\n 16, Adenoid cystic carcinoma 8200/3 \\n 17, Unclassified carcinoma \\n 18, Others \\n 19, Large cell neuroendocrine carcinoma  8013/3', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''4''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'lab_diagn_lung', NULL, 'pathology_review', NULL, 126, NULL, NULL, 'select', 'Lab_Diagn_Lung', '1, Squamous cell carcinoma 8070/3 \\n 2, Small cell carcinoma 8041/3 \\n 3, Adenocarcinoma 8140/3 \\n 4, Adenocarcinoma, mixed subtype 8255/3 \\n 5, Adenocarcinoma, Acinar 8550/3 \\n 6, Adenocarcinoma, Papillary 8260/3 \\n 7, Adenocarcinoma, Micropapillary \\n 8, Bronchioloalveolar carcinoma 8250/3 \\n 9, Solid adenocarcinoma with mucin 8230/3 \\n 10, Adenosquamous carcinoma 8560/3 \\n 11, Large cell carcinoma 8012/3 \\n 12, Sarcomatoid carcinoma 8033/3 \\n 13, Carcinoid tumour 8240/3 \\n 14, Mucoepidermoid carcinoma 8430/3 \\n 15, Epithelial-myoepithelial carcinoma 8562/3 \\n 16, Adenoid cystic carcinoma 8200/3 \\n 17, Unclassified carcinoma \\n 18, Others \\n 19, Large cell neuroendocrine carcinoma 8013/3', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''4''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'if_others_specify', NULL, 'pathology_review', NULL, 127, NULL, NULL, 'text', 'If_Others_Specify', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''4'' and [lab_diagn_lung] = ''10''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'clin_grade_lung', NULL, 'pathology_review', NULL, 128, NULL, NULL, 'select', 'Clin_Grade_Lung', '1, Low \\n 2, Intermediate \\n 3, High \\n 4, N/A \\n 5, Low-Intermediate \\n 6, Intermediate-High', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''4''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'lab_grade_lung', NULL, 'pathology_review', NULL, 129, NULL, NULL, 'select', 'Lab_Grade_Lung', '1, Low \\n 2, Intermediate \\n 3, High \\n 4, N/A', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''4''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tnmlung_t', NULL, 'pathology_review', NULL, 130, NULL, NULL, 'select', 'TNMlung_T', '1, TX \\n 2, T0 No evidence of primary tumour \\n 3, Tis Carcinoma in situ \\n 4, T1 <= 3 cm, without invasion \\n 5, T2 > 3 cm; or involves main bronchus(>2 cm distal to carina)/visceral pleura; or Associated with atelectasis or obstructive pneumonitis that does not involve entire lung \\n 6, T3 any size that directly invades any of:chest wall, diaphragm, mediastinal pleura, parietal pericardium; or tumour in main bronchus < 2 cm distal to carina but without involvement of carina; or associated atelectasis or obstructive pneumonitis of entire lung \\n 7, T4 any size that invades any of: mediastinum, heart, great vessels, trachea, oesophagus, vertebral body, carina; separate tumour nodule(s) in same lobe; tumour with malignant pleural effusion', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''4''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tnmlung_n', NULL, 'pathology_review', NULL, 131, NULL, NULL, 'select', 'TNMlung_N', '8, NX \\n 9, N0 \\n 10, N1 Ipsilateral peribronchial/ipsilateral hilar LNs and intrapulmonary LNs \\n 11, N2 ipsilateral mediastinal/subcarinal LNs \\n 12, N3 contralateral mediastinal, contralateral hilar, ipsilateral or contralateral scalene, or supraclavicular LNs', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''4''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tnmlung_m', NULL, 'pathology_review', NULL, 132, NULL, NULL, 'select', 'TNMlung_M', '13, MX \\n 14, M0 \\n 15, M1 Distant metastasis, includes separate tumour nodule(s) in different lobe', NULL, NULL, NULL, NULL, NULL, '[tumor_origin] = ''4''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'clin_diagn_others', NULL, 'pathology_review', NULL, 133, NULL, 'For Other Cancer Samples', 'text', 'Clin_Diagn_Others', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''5''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'lab_diagn_others', NULL, 'pathology_review', NULL, 134, NULL, NULL, 'text', 'Lab_Diagn_Others', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''5''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'clin_grade_others', NULL, 'pathology_review', NULL, 135, NULL, NULL, 'text', 'Clin_Grade_Others', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''5''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'lab_grade_others', NULL, 'pathology_review', NULL, 136, NULL, NULL, 'text', 'Lab_Grade_Others', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''5''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tnm_stage', NULL, 'pathology_review', NULL, 137, NULL, NULL, 'text', 'TNM_Stage', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[tumor_origin] = ''5''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'pathoireview_note', NULL, 'pathology_review', NULL, 138, NULL, NULL, 'textarea', 'PatholReview_Note', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'pathology_review_complete', NULL, 'pathology_review', NULL, 139, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'five_um_tumor_quant', NULL, 'slide_information', 'Slide Information', 140, NULL, NULL, 'text', '5um_Tumor_Quant', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'five_um_tumor_currquant', NULL, 'slide_information', NULL, 141, NULL, NULL, 'text', '5um_Tumor_CurrQuant', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'ten_um_tumor_quant', NULL, 'slide_information', NULL, 142, NULL, NULL, 'text', '10um_Tumor_Quant', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'ten_um_tumor_currquant', NULL, 'slide_information', NULL, 143, NULL, NULL, 'text', '10um_Tumor_CurrQuant', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'five_um_nor_quant', NULL, 'slide_information', NULL, 144, NULL, NULL, 'text', '5um_Nor_Quant', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'five_um_nor_currquant', NULL, 'slide_information', NULL, 145, NULL, NULL, 'text', '5um_Nor_CurrQuant', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'ten_um_nor_quant', NULL, 'slide_information', NULL, 146, NULL, NULL, 'text', '10um_Nor_Quant', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'ten_um_nor_currquant', NULL, 'slide_information', NULL, 147, NULL, NULL, 'text', '10um_Nor_CurrQuant', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'slideloc_1', NULL, 'slide_information', NULL, 148, NULL, NULL, 'text', 'SlideLoc_1', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'parapieceloc_1', NULL, 'slide_information', NULL, 149, NULL, NULL, 'text', 'ParaPieceLoc_1', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'is_there_another_accnumber', NULL, 'slide_information', NULL, 150, NULL, NULL, 'yesno', 'Is there another AccNumber?', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'pathaccnum_2', NULL, 'slide_information', NULL, 151, NULL, NULL, 'text', 'PathAccNum_2', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[is_there_another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'five_um_tumor_quant2', NULL, 'slide_information', NULL, 152, NULL, NULL, 'text', '5um_Tumor_Quant2', NULL, NULL, 'float', NULL, NULL, 'soft_typed', '[is_there_another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'five_um_tumor_currquant2', NULL, 'slide_information', NULL, 153, NULL, NULL, 'text', '5um_Tumor_CurrQuant2', NULL, NULL, 'float', NULL, NULL, 'soft_typed', '[is_there_another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'ten_um_tumor_quant2', NULL, 'slide_information', NULL, 154, NULL, NULL, 'text', '10um_Tumor_Quant2', NULL, NULL, 'float', NULL, NULL, 'soft_typed', '[is_there_another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'ten_um_tumor_currquant2', NULL, 'slide_information', NULL, 155, NULL, NULL, 'text', '10um_Tumor_CurrQuant2', NULL, NULL, 'float', NULL, NULL, 'soft_typed', '[is_there_another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'five_um_nor_quant2', NULL, 'slide_information', NULL, 156, NULL, NULL, 'text', '5um_Nor_Quant2', NULL, NULL, 'float', NULL, NULL, 'soft_typed', '[is_there_another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'five_um_nor_currquant2', NULL, 'slide_information', NULL, 157, NULL, NULL, 'text', '5um_Nor_CurrQuant2', NULL, NULL, 'float', NULL, NULL, 'soft_typed', '[is_there_another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'ten_um_nor_quant2', NULL, 'slide_information', NULL, 158, NULL, NULL, 'text', '10um_Nor_Quant2', NULL, NULL, 'float', NULL, NULL, 'soft_typed', '[is_there_another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'ten_um_nor_currquant2', NULL, 'slide_information', NULL, 159, NULL, NULL, 'text', '10um_Nor_CurrQuant2', NULL, NULL, 'float', NULL, NULL, 'soft_typed', '[is_there_another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'same_slideloc', NULL, 'slide_information', NULL, 160, NULL, NULL, 'yesno', 'Same_SlideLoc?', NULL, NULL, NULL, NULL, NULL, NULL, '[is_there_another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'if_no_location2', NULL, 'slide_information', NULL, 161, NULL, NULL, 'text', 'If_No_Location2', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[same_slideloc] = ''0'' and [is_there_another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'parapieceloc_2', NULL, 'slide_information', NULL, 162, NULL, NULL, 'text', 'ParaPieceLoc_2', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[is_there_another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'is_there_metastatic_tumor', NULL, 'slide_information', NULL, 163, NULL, NULL, 'yesno', 'Is there Metastatic Tumor?', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'metastatic_accnum', NULL, 'slide_information', NULL, 164, NULL, NULL, 'text', 'Metastatic_AccNum', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[is_there_metastatic_tumor] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'five_um_met_quant', NULL, 'slide_information', NULL, 165, NULL, NULL, 'text', '5um_Met_Quant', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[is_there_metastatic_tumor] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'five_um_met_currentquant', NULL, 'slide_information', NULL, 166, NULL, NULL, 'text', '5um_Met_CurrentQuant', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[is_there_metastatic_tumor] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'ten_um_met_quant', NULL, 'slide_information', NULL, 167, NULL, NULL, 'text', '10um_Met_Quant', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[is_there_metastatic_tumor] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'ten_um_met_currentquant', NULL, 'slide_information', NULL, 168, NULL, NULL, 'text', '10um_Met_CurrentQuant', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[is_there_metastatic_tumor] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'slideloc_metmetastatic', NULL, 'slide_information', NULL, 169, NULL, NULL, 'text', 'SlideLoc_Metmetastatic', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[is_there_metastatic_tumor] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'parapieceloc_metastatic', NULL, 'slide_information', NULL, 170, NULL, NULL, 'text', 'ParaPieceLoc_Metastatic', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[is_there_metastatic_tumor] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'is_there_precancer', NULL, 'slide_information', NULL, 171, NULL, NULL, 'yesno', 'Is There Precancer?', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'precancer_accnum', NULL, 'slide_information', NULL, 172, NULL, NULL, 'text', 'PreCancer_AccNum', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[is_there_precancer] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'five_um_precancer_quant', NULL, 'slide_information', NULL, 173, NULL, NULL, 'text', '5um_Precancer_Quant', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[is_there_precancer] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'five_um_precancer_curquant', NULL, 'slide_information', NULL, 174, NULL, NULL, 'text', '5um_Precancer_CurrentQuant', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[is_there_precancer] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'ten_um_precancer_quant', NULL, 'slide_information', NULL, 175, NULL, NULL, 'text', '10um_Precancer_Quant', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[is_there_precancer] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'ten_um_precancer_curquant', NULL, 'slide_information', NULL, 176, NULL, NULL, 'text', '10um_Precancer_CurQuant', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[is_there_precancer] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'slideloc_precancer', NULL, 'slide_information', NULL, 177, NULL, NULL, 'text', 'SlideLoc_Precancer', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[is_there_precancer] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'parapieceloc_precancer', NULL, 'slide_information', NULL, 178, NULL, NULL, 'text', 'ParaPieceLoc_Precancer', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[is_there_precancer] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'slide_information_complete', NULL, 'slide_information', NULL, 179, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tma_ca_pos1', NULL, 'tma_information', 'TMA Information', 180, NULL, NULL, 'text', 'TMA_Ca_pos1', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tma_ca_pos2', NULL, 'tma_information', NULL, 181, NULL, NULL, 'text', 'TMA_Ca_pos2', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tma_nor_pos1', NULL, 'tma_information', NULL, 182, NULL, NULL, 'text', 'TMA_Nor_pos1', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tma_nor_pos2', NULL, 'tma_information', NULL, 183, NULL, NULL, 'text', 'TMA_Nor_pos2', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tma_preca_pos', NULL, 'tma_information', NULL, 184, NULL, NULL, 'text', 'TMA_ PreCa_pos1', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tma_metastatic_pos', NULL, 'tma_information', NULL, 185, NULL, NULL, 'text', 'TMA Metastatic_pos1', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO redcap_metadata (project_id, field_name, field_phi, form_name, form_menu_description, field_order, field_units, element_preceding_header, element_type, element_label, element_enum, element_note, element_validation_type, element_validation_min, element_validation_max, element_validation_checktype, branching_logic, field_req, edoc_id, edoc_display_img, custom_alignment, stop_actions, question_num, grid_name, misc) VALUES
(@project_id, 'another_accnumber', NULL, 'tma_information', NULL, 186, NULL, NULL, 'yesno', 'Another_AccNumber?', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tma_ca_pos3', NULL, 'tma_information', NULL, 187, NULL, NULL, 'text', 'TMA_Ca_pos3', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tma_ca_pos4', NULL, 'tma_information', NULL, 188, NULL, NULL, 'text', 'TMA_Ca_pos4', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tma_nor_pos3', NULL, 'tma_information', NULL, 189, NULL, NULL, 'text', 'TMA_Nor_pos3', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tma_nor_pos4', NULL, 'tma_information', NULL, 190, NULL, NULL, 'text', 'TMA_Nor_pos4', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tma_preca_pos2', NULL, 'tma_information', NULL, 191, NULL, NULL, 'text', 'TMA_ PreCa_pos2', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tma_metastatic_pos2', NULL, 'tma_information', NULL, 192, NULL, NULL, 'text', 'TMA Metastatic_pos2', NULL, NULL, NULL, NULL, NULL, 'soft_typed', '[another_accnumber] = ''1''', 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'tma_information_complete', NULL, 'tma_information', NULL, 193, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'pulling_date1', NULL, 'slide_tracking', 'Slide Tracking', 194, NULL, NULL, 'text', 'Pulling_Date1', NULL, NULL, 'date_mdy', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'forwhoseproject', NULL, 'slide_tracking', NULL, 195, NULL, NULL, 'text', 'ForWhoseProject1', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'whichslidepulled1', NULL, 'slide_tracking', NULL, 196, NULL, NULL, 'text', 'WhichSlidePulled1', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'pulled_quant1', NULL, 'slide_tracking', NULL, 197, NULL, NULL, 'text', 'Pulled_Quant1', NULL, NULL, 'float', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL),
(@project_id, 'slide_tracking_complete', NULL, 'slide_tracking', NULL, 198, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL, NULL, NULL);

INSERT INTO `redcap_projects_templates` (`project_id`, `title`, `description`, `enabled`)
	VALUES (@project_id,  @project_title,  'Five data entry forms for collecting and tracking information for cancer tissue.',  '1');