<?php
namespace Vanderbilt\REDCap\Classes\DTOs;

use System;


/**
 * REDCap configuration variables
 * from the redcap_config table
 */
final class REDCapConfigDTO extends DTO {
    public $aafAccessUrl;
    public $aafAllowLocalsCreateDB;
    public $aafAud;
    public $aafDisplayOnEmailUsers;
    public $aafIss;
    public $aafPrimaryField;
    public $aafScopeTarget;
    public $alerts_allow_email_freeform;
    public $alerts_allow_email_variables;
    public $alerts_allow_phone_freeform;
    public $alerts_allow_phone_variables;
    public $alerts_email_freeform_domain_allowlist;
    public $allow_create_db_default;
    public $allow_kill_mysql_process;
    public $allow_outbound_http;
    public $amazon_s3_bucket;
    public $amazon_s3_endpoint;
    public $amazon_s3_endpoint_url;
    public $amazon_s3_key;
    public $amazon_s3_secret;
    public $api_enabled;
    public $api_token_request_type;
    public $auth_meth_global;
    public $auto_prod_changes;
    public $auto_prod_changes_check_identifiers;
    public $auto_report_stats;
    public $auto_report_stats_last_sent;
    public $autologout_timer;
    public $aws_quickstart;
    public $azure_app_name;
    public $azure_app_secret;
    public $azure_container;
    public $azure_quickstart;
    public $bioportal_api_token;
    public $bioportal_api_url;
    public $bioportal_ontology_list;
    public $bioportal_ontology_list_cache_time;
    public $cache_storage_system;
    public $cache_files_filesystem_path;
    public $calendar_feed_enabled_global;
    public $certify_text_create;
    public $certify_text_prod;
    public $clickjacking_prevention;
    public $config_settings_key;
    public $contact_admin_button_url;
    public $cron_job_php_ini_file;
    public $cross_domain_access_control;
    public $data_entry_trigger_enabled;
    public $database_query_tool_enabled;
    public $db_binlog_format;
    public $db_character_set;
    public $db_collation;
    public $default_csv_delimiter;
    public $default_datetime_format;
    public $default_number_format_decimal;
    public $default_number_format_thousands_sep;
    public $display_project_logo_institution;
    public $display_project_xml_backup_option;
    public $display_today_now_button;
    public $dkim_private_key;
    public $drw_upload_option_enabled;
    public $dts_enabled_global;
    public $edoc_field_option_enabled;
    public $edoc_path;
    public $edoc_storage_option;
    public $edoc_upload_max;
    public $email_domain_allowlist;
    public $email_logging_enable_global;
    public $email_logging_install_time;
    public $enable_edit_prod_events;
    public $enable_edit_prod_repeating_setup;
    public $enable_edit_survey_response;
    public $enable_field_attachment_video_url;
    public $enable_http_compression;
    public $enable_ontology_auto_suggest;
    public $enable_plotting;
    public $enable_plotting_survey_results;
    public $enable_projecttype_forms;
    public $enable_projecttype_singlesurvey;
    public $enable_projecttype_singlesurveyforms;
    public $enable_survey_text_to_speech;
    public $enable_url_shortener;
    public $enable_user_allowlist;
    public $esignature_enabled_global;
    public $external_module_alt_paths;
    public $external_modules_allow_activation_user_request;
    public $external_modules_project_custom_text;
    public $external_modules_unsafe_edoc_references_checked;
    public $external_modules_updates_available;
    public $external_modules_updates_available_last_check;
    public $fhir_break_the_glass_department_type;
    public $fhir_break_the_glass_ehr_usertype;
    public $fhir_break_the_glass_enabled;
    public $fhir_break_the_glass_patient_type;
    public $fhir_break_the_glass_token_password;
    public $fhir_break_the_glass_token_username;
    public $fhir_break_the_glass_token_usertype;
    public $fhir_break_the_glass_username_token_base_url;
    public $fhir_cdp_allow_auto_adjudication;
    public $fhir_client_id;
    public $fhir_client_secret;
    public $fhir_convert_timestamp_from_gmt;
    public $fhir_custom_text;
    public $fhir_data_fetch_interval;
    public $fhir_data_mart_create_project;
    public $fhir_ddp_enabled;
    public $fhir_display_info_project_setup;
    public $fhir_include_email_address;
    public $fhir_source_system_custom_name;
    public $fhir_standalone_authentication_flow;
    public $fhir_stop_fetch_inactivity_days;
    public $fhir_url_user_access;
    public $fhir_custom_mapping_file_id;
    public $fhir_custom_auth_params;
    public $fhir_user_rights_super_users_only;
    public $field_bank_enabled;
    public $field_comment_log_enabled_default;
    public $file_attachment_upload_max;
    public $file_repository_enabled;
    public $file_repository_upload_max;
    public $file_upload_vault_filesystem_authtype;
    public $file_upload_vault_filesystem_container;
    public $file_upload_vault_filesystem_host;
    public $file_upload_vault_filesystem_password;
    public $file_upload_vault_filesystem_path;
    public $file_upload_vault_filesystem_private_key_path;
    public $file_upload_vault_filesystem_type;
    public $file_upload_vault_filesystem_username;
    public $file_upload_versioning_enabled;
    public $file_upload_versioning_global_enabled;
    public $footer_links;
    public $footer_text;
    public $from_email;
    public $from_email_domain_exclude;
    public $google_cloud_storage_api_bucket_name;
    public $google_cloud_storage_api_project_id;
    public $google_cloud_storage_api_service_account;
    public $google_cloud_storage_api_use_project_subfolder;
    public $google_cloud_storage_edocs_bucket;
    public $google_cloud_storage_temp_bucket;
    public $google_oauth2_client_id;
    public $google_oauth2_client_secret;
    public $google_recaptcha_secret_key;
    public $google_recaptcha_site_key;
    public $google_translate_enabled;
    public $googlemap_key;
    public $grant_cite;
    public $headerlogo;
    public $helpfaq_custom_text;
    public $homepage_announcement;
    public $homepage_announcement_login;
    public $homepage_contact;
    public $homepage_contact_email;
    public $homepage_contact_url;
    public $homepage_custom_text;
    public $homepage_grant_cite;
    public $hook_functions_file;
    public $identifier_keywords;
    public $institution;
    public $is_development_server;
    public $language_global;
    public $login_autocomplete_disable;
    public $login_custom_text;
    public $login_logo;
    public $logout_fail_limit;
    public $logout_fail_window;
    public $mailgun_api_key;
    public $mailgun_domain_name;
    public $mandrill_api_key;
    public $mobile_app_enabled;
    public $my_profile_enable_edit;
    public $my_profile_enable_primary_email_edit;
    public $new_form_default_prod_user_access;
    public $oauth2_azure_ad_client_id;
    public $oauth2_azure_ad_client_secret;
    public $oauth2_azure_ad_endpoint_version;
    public $oauth2_azure_ad_primary_admin;
    public $oauth2_azure_ad_secondary_admin;
    public $oauth2_azure_ad_username_attribute;
    public $openid_connect_client_id;
    public $openid_connect_client_secret;
    public $openid_connect_metadata_url;
    public $openid_connect_name;
    public $openid_connect_primary_admin;
    public $openid_connect_provider_url;
    public $openid_connect_secondary_admin;
    public $openid_connect_username_attribute;
    public $openid_provider_name;
    public $openid_provider_url;
    public $override_system_bundle_ca;
    public $page_hit_threshold_per_minute;
    public $password_algo;
    public $password_complexity;
    public $password_history_limit;
    public $password_length;
    public $password_recovery_custom_text;
    public $password_reset_duration;
    public $pdf_econsent_filesystem_authtype;
    public $pdf_econsent_filesystem_container;
    public $pdf_econsent_filesystem_host;
    public $pdf_econsent_filesystem_password;
    public $pdf_econsent_filesystem_path;
    public $pdf_econsent_filesystem_private_key_path;
    public $pdf_econsent_filesystem_type;
    public $pdf_econsent_filesystem_username;
    public $pdf_econsent_system_custom_text;
    public $pdf_econsent_system_enabled;
    public $pdf_econsent_system_ip;
    public $project_contact_email;
    public $project_contact_name;
    public $project_dashboard_allow_public;
    public $project_dashboard_min_data_points;
    public $project_encoding;
    public $project_language;
    public $promis_api_base_url;
    public $promis_enabled;
    public $promis_registration_id;
    public $promis_token;
    public $protected_email_mode_global;
    public $proxy_hostname;
    public $proxy_username_password;
    public $pub_matching_email_days;
    public $pub_matching_email_limit;
    public $pub_matching_email_subject;
    public $pub_matching_email_text;
    public $pub_matching_emails;
    public $pub_matching_enabled;
    public $pub_matching_institution;
    public $randomization_global;
    public $realtime_webservice_convert_timestamp_from_gmt;
    public $realtime_webservice_custom_text;
    public $realtime_webservice_data_fetch_interval;
    public $realtime_webservice_display_info_project_setup;
    public $realtime_webservice_global_enabled;
    public $realtime_webservice_source_system_custom_name;
    public $realtime_webservice_stop_fetch_inactivity_days;
    public $realtime_webservice_url_data;
    public $realtime_webservice_url_metadata;
    public $realtime_webservice_url_user_access;
    public $realtime_webservice_user_rights_super_users_only;
    public $record_locking_pdf_vault_filesystem_authtype;
    public $record_locking_pdf_vault_filesystem_container;
    public $record_locking_pdf_vault_filesystem_host;
    public $record_locking_pdf_vault_filesystem_password;
    public $record_locking_pdf_vault_filesystem_path;
    public $record_locking_pdf_vault_filesystem_private_key_path;
    public $record_locking_pdf_vault_filesystem_type;
    public $record_locking_pdf_vault_filesystem_username;
    public $redcap_base_url;
    public $redcap_base_url_display_error_on_mismatch;
    public $redcap_last_install_date;
    public $redcap_survey_base_url;
    public $redcap_updates_available;
    public $redcap_updates_available_last_check;
    public $redcap_updates_community_password;
    public $redcap_updates_community_user;
    public $redcap_updates_password;
    public $redcap_updates_password_encrypted;
    public $redcap_updates_user;
    public $redcap_version;
    public $report_stats_url;
    public $reports_allow_public;
    public $rewards_enable_type;
    public $rewards_enabled_by_super_users_only;
    public $rewards_enabled_global;
    public $rewards_enablement_message;
    public $rich_text_image_embed_enabled;
    public $sams_logout;
    public $send_emails_admin_tasks;
    public $sendgrid_api_key;
    public $sendgrid_display_info_project_setup;
    public $sendgrid_enabled_by_super_users_only;
    public $sendgrid_enabled_global;
    public $sendit_enabled;
    public $sendit_upload_max;
    public $shared_library_enabled;
    public $shibboleth_logout;
    public $shibboleth_override_userinfo;
    public $shibboleth_set_userinfo;
    public $shibboleth_table_config;
    public $shibboleth_user_firstname_field;
    public $shibboleth_user_lastname_field;
    public $shibboleth_user_email_field;
    public $shibboleth_username_field;
    public $site_org_type;
    public $superusers_only_create_project;
    public $superusers_only_move_to_prod;
    public $survey_pid_create_project;
    public $survey_pid_mark_completed;
    public $survey_pid_move_to_analysis_status;
    public $survey_pid_move_to_prod_status;
    public $suspend_users_inactive_days;
    public $suspend_users_inactive_send_email;
    public $suspend_users_inactive_type;
    public $system_offline;
    public $system_offline_message;
    public $temp_files_last_delete;
    public $twilio_display_info_project_setup;
    public $twilio_enabled_by_super_users_only;
    public $twilio_enabled_global;
    public $two_factor_auth_authenticator_enabled;
    public $two_factor_auth_duo_enabled;
    public $two_factor_auth_duo_hostname;
    public $two_factor_auth_duo_ikey;
    public $two_factor_auth_duo_skey;
    public $two_factor_auth_email_enabled;
    public $two_factor_auth_enabled;
    public $two_factor_auth_enforce_table_users_only;
    public $two_factor_auth_esign_pin;
    public $two_factor_auth_ip_check_enabled;
    public $two_factor_auth_ip_range;
    public $two_factor_auth_ip_range_alt;
    public $two_factor_auth_ip_range_include_private;
    public $two_factor_auth_trust_period_days;
    public $two_factor_auth_trust_period_days_alt;
    public $two_factor_auth_twilio_account_sid;
    public $two_factor_auth_twilio_auth_token;
    public $two_factor_auth_twilio_enabled;
    public $two_factor_auth_twilio_from_number;
    public $two_factor_auth_twilio_from_number_voice_alt;
    public $use_email_display_name;
    public $user_access_dashboard_custom_notification;
    public $user_access_dashboard_enable;
    public $user_messaging_enabled;
    public $user_messaging_prevent_admin_messaging;
    public $user_sponsor_dashboard_enable;
    public $user_sponsor_set_expiration_days;
    public $user_custom_expiration_message;
    public $user_with_sponsor_custom_expiration_message;

    /**
     * get a set of REDCap configuration directly from the database
     *
     * @return REDCapConfigDTO
     */
    public static function fromDB() {
        return REDCapConfigDTO::fromArray(System::getConfigVals());
    }
}