
-- SQL TO CREATE A REDCAP DEMO PROJECT --
set @project_title = 'Randomized Clinical Trial';


-- Obtain default values --
set @institution = (select value from redcap_config where field_name = 'institution' limit 1);
set @site_org_type = (select value from redcap_config where field_name = 'site_org_type' limit 1);
set @grant_cite = (select value from redcap_config where field_name = 'grant_cite' limit 1);
set @project_contact_name = (select value from redcap_config where field_name = 'project_contact_name' limit 1);
set @project_contact_email = (select value from redcap_config where field_name = 'project_contact_email' limit 1);
set @headerlogo = (select value from redcap_config where field_name = 'headerlogo' limit 1);
set @auth_meth = (select value from redcap_config where field_name = 'auth_meth_global' limit 1);
-- Create project --
INSERT INTO `redcap_projects`
(project_name, app_title, status, count_project, auth_meth, creation_time, production_time, institution, site_org_type, grant_cite, project_contact_name, project_contact_email, headerlogo, display_project_logo_institution, randomization, auto_inc_set) VALUES
(concat('redcap_demo_',LEFT(sha1(rand()),6)), @project_title, 1, 0, @auth_meth, now(), now(), @institution, @site_org_type, @grant_cite, @project_contact_name, @project_contact_email, @headerlogo, 0, 1, 1);
set @project_id = LAST_INSERT_ID();
-- Create single arm --
INSERT INTO redcap_events_arms (project_id, arm_num, arm_name) VALUES (@project_id, 1, 'Arm 1');
set @arm_id = LAST_INSERT_ID();
-- Create single event --
INSERT INTO redcap_events_metadata (arm_id, day_offset, offset_min, offset_max, descrip) VALUES (@arm_id, 0, 0, 0, 'Event 1');
set @event_id = LAST_INSERT_ID();
-- Insert randomization row
INSERT INTO redcap_randomization (project_id, stratified, group_by, target_field, target_event, source_field1, source_event1, source_field2, source_event2, source_field3, source_event3, source_field4, source_event4, source_field5, source_event5, source_field6, source_event6, source_field7, source_event7, source_field8, source_event8, source_field9, source_event9, source_field10, source_event10, source_field11, source_event11, source_field12, source_event12, source_field13, source_event13, source_field14, source_event14, source_field15, source_event15) VALUES
(@project_id, 1, NULL, 'randomization_group', NULL, 'race', @event_id, 'sex', @event_id, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
-- Insert into redcap_metadata --
INSERT INTO redcap_metadata (project_id, field_name, field_phi, form_name, form_menu_description, field_order, field_units, element_preceding_header, element_type, element_label, element_enum, element_note, element_validation_type, element_validation_min, element_validation_max, element_validation_checktype, branching_logic, field_req, edoc_id, edoc_display_img, custom_alignment, stop_actions, question_num) VALUES
(@project_id, 'study_id', NULL, 'demographics', 'Demographics', 1, NULL, NULL, 'text', 'Study ID', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'date_enrolled', NULL, 'demographics', NULL, 2, NULL, 'Consent Information', 'text', 'Date subject signed consent', NULL, 'YYYY-MM-DD', 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'first_name', '1', 'demographics', NULL, 3, NULL, 'Contact Information', 'text', 'First Name', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'last_name', '1', 'demographics', NULL, 4, NULL, NULL, 'text', 'Last Name', NULL, NULL, NULL, NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'dob', '1', 'demographics', NULL, 8.1, NULL, NULL, 'text', 'Date of birth', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'ethnicity', NULL, 'demographics', NULL, 9, NULL, NULL, 'radio', 'Ethnicity', '0, Hispanic or Latino \\n 1, NOT Hispanic or Latino \\n 2, Unknown / Not Reported', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, 'LH', NULL, NULL),
(@project_id, 'race', NULL, 'demographics', NULL, 10, NULL, NULL, 'select', 'Race', '0, American Indian/Alaska Native \\n 1, Asian \\n 2, Native Hawaiian or Other Pacific Islander \\n 3, Black or African American \\n 4, White \\n 5, More Than One Race \\n 6, Unknown / Not Reported', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'sex', NULL, 'demographics', NULL, 11, NULL, NULL, 'radio', 'sex', '0, Female \\n 1, Male \\n 2, Other \\n 3, Prefer not to say', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'demographics_complete', NULL, 'demographics', NULL, 23, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),

(@project_id, 'randomization_group', NULL, 'randomization_form', 'Randomization Form', 23.1, NULL, 'General Comments', 'select', 'Randomization Group', '0, Drug A \\n 1, Drug B \\n 2, Drug C', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'randomization_form_complete', NULL, 'randomization_form', NULL, 23.2, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),


(@project_id, 'date_visit_b', NULL, 'baseline_data', 'Baseline Data', 24, NULL, 'Baseline Measurements', 'text', 'Date of baseline visit', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'date_blood_b', NULL, 'baseline_data', NULL, 25, NULL, NULL, 'text', 'Date blood was drawn', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'alb_b', NULL, 'baseline_data', NULL, 26, 'g/dL', NULL, 'text', 'Serum Albumin (g/dL)', NULL, NULL, 'int', '3', '5', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'prealb_b', NULL, 'baseline_data', NULL, 27, 'mg/dL', NULL, 'text', 'Serum Prealbumin (mg/dL)', NULL, NULL, 'float', '10', '40', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'creat_b', NULL, 'baseline_data', NULL, 28, 'mg/dL', NULL, 'text', 'Creatinine (mg/dL)', NULL, NULL, 'float', '0.5', '20', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'npcr_b', NULL, 'baseline_data', NULL, 29, 'g/kg/d', NULL, 'text', 'Normalized Protein Catabolic Rate (g/kg/d)', NULL, NULL, 'float', '0.5', '2', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'chol_b', NULL, 'baseline_data', NULL, 30, 'mg/dL', NULL, 'text', 'Cholesterol (mg/dL)', NULL, NULL, 'float', '100', '300', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'transferrin_b', NULL, 'baseline_data', NULL, 31, 'mg/dL', NULL, 'text', 'Transferrin (mg/dL)', NULL, NULL, 'float', '100', '300', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'kt_v_b', NULL, 'baseline_data', NULL, 32, NULL, NULL, 'text', 'Kt/V', NULL, NULL, 'float', '0.9', '3', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'drywt_b', NULL, 'baseline_data', NULL, 33, 'kilograms', NULL, 'text', 'Dry weight (kilograms)', NULL, NULL, 'float', '35', '200', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'plasma1_b', NULL, 'baseline_data', NULL, 34, NULL, NULL, 'select', 'Collected Plasma 1?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'plasma2_b', NULL, 'baseline_data', NULL, 35, NULL, NULL, 'select', 'Collected Plasma 2?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'plasma3_b', NULL, 'baseline_data', NULL, 36, NULL, NULL, 'select', 'Collected Plasma 3?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'serum1_b', NULL, 'baseline_data', NULL, 37, NULL, NULL, 'select', 'Collected Serum 1?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'serum2_b', NULL, 'baseline_data', NULL, 38, NULL, NULL, 'select', 'Collected Serum 2?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'serum3_b', NULL, 'baseline_data', NULL, 39, NULL, NULL, 'select', 'Collected Serum 3?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'sga_b', NULL, 'baseline_data', NULL, 40, NULL, NULL, 'text', 'Subject Global Assessment (score = 1-7)', NULL, NULL, 'float', '0.9', '7.1', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'date_supplement_dispensed', NULL, 'baseline_data', NULL, 41, NULL, NULL, 'text', 'Date patient begins supplement', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'baseline_data_complete', NULL, 'baseline_data', NULL, 42, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'date_visit_1', NULL, 'month_1_data', 'Month 1 Data', 43, NULL, 'Month 1', 'text', 'Date of Month 1 visit', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'alb_1', NULL, 'month_1_data', NULL, 44, 'g/dL', NULL, 'text', 'Serum Albumin (g/dL)', NULL, NULL, 'float', '3', '5', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'prealb_1', NULL, 'month_1_data', NULL, 45, 'mg/dL', NULL, 'text', 'Serum Prealbumin (mg/dL)', NULL, NULL, 'float', '10', '40', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'creat_1', NULL, 'month_1_data', NULL, 46, 'mg/dL', NULL, 'text', 'Creatinine (mg/dL)', NULL, NULL, 'float', '0.5', '20', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'npcr_1', NULL, 'month_1_data', NULL, 47, 'g/kg/d', NULL, 'text', 'Normalized Protein Catabolic Rate (g/kg/d)', NULL, NULL, 'float', '0.5', '2', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'chol_1', NULL, 'month_1_data', NULL, 48, 'mg/dL', NULL, 'text', 'Cholesterol (mg/dL)', NULL, NULL, 'float', '100', '300', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'transferrin_1', NULL, 'month_1_data', NULL, 49, 'mg/dL', NULL, 'text', 'Transferrin (mg/dL)', NULL, NULL, 'float', '100', '300', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'kt_v_1', NULL, 'month_1_data', NULL, 50, NULL, NULL, 'text', 'Kt/V', NULL, NULL, 'float', '0.9', '3', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'drywt_1', NULL, 'month_1_data', NULL, 51, 'kilograms', NULL, 'text', 'Dry weight (kilograms)', NULL, NULL, 'float', '35', '200', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'no_show_1', NULL, 'month_1_data', NULL, 52, NULL, NULL, 'text', 'Number of treatments missed', NULL, NULL, 'float', '0', '7', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'compliance_1', NULL, 'month_1_data', NULL, 53, NULL, NULL, 'select', 'How compliant was the patient in drinking the supplement?', '0, 100 percent \\n 1, 99-75 percent \\n 2, 74-50 percent \\n 3, 49-25 percent \\n 4, 0-24 percent', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'hospit_1', NULL, 'month_1_data', NULL, 54, NULL, 'Hospitalization Data', 'select', 'Was patient hospitalized since last visit?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'cause_hosp_1', NULL, 'month_1_data', NULL, 55, NULL, NULL, 'select', 'What was the cause of hospitalization?', '1, Vascular access related events \\n 2, CVD events \\n 3, Other', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'admission_date_1', NULL, 'month_1_data', NULL, 56, NULL, NULL, 'text', 'Date of hospital admission', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'discharge_date_1', NULL, 'month_1_data', NULL, 57, NULL, NULL, 'text', 'Date of hospital discharge', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'discharge_summary_1', NULL, 'month_1_data', NULL, 58, NULL, NULL, 'select', 'Discharge summary in patients binder?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'death_1', NULL, 'month_1_data', NULL, 59, NULL, 'Mortality Data', 'select', 'Has patient died since last visit?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'date_death_1', NULL, 'month_1_data', NULL, 60, NULL, NULL, 'text', 'Date of death', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'cause_death_1', NULL, 'month_1_data', NULL, 61, NULL, NULL, 'select', 'What was the cause of death?', '1, All-cause \\n 2, Cardiovascular', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'month_1_data_complete', NULL, 'month_1_data', NULL, 62, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'date_visit_2', NULL, 'month_2_data', 'Month 2 Data', 63, NULL, 'Month 2', 'text', 'Date of Month 2 visit', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'alb_2', NULL, 'month_2_data', NULL, 64, 'g/dL', NULL, 'text', 'Serum Albumin (g/dL)', NULL, NULL, 'float', '3', '5', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'prealb_2', NULL, 'month_2_data', NULL, 65, 'mg/dL', NULL, 'text', 'Serum Prealbumin (mg/dL)', NULL, NULL, 'float', '10', '40', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'creat_2', NULL, 'month_2_data', NULL, 66, 'mg/dL', NULL, 'text', 'Creatinine (mg/dL)', NULL, NULL, 'float', '0.5', '20', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'npcr_2', NULL, 'month_2_data', NULL, 67, 'g/kg/d', NULL, 'text', 'Normalized Protein Catabolic Rate (g/kg/d)', NULL, NULL, 'float', '0.5', '2', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'chol_2', NULL, 'month_2_data', NULL, 68, 'mg/dL', NULL, 'text', 'Cholesterol (mg/dL)', NULL, NULL, 'float', '100', '300', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'transferrin_2', NULL, 'month_2_data', NULL, 69, 'mg/dL', NULL, 'text', 'Transferrin (mg/dL)', NULL, NULL, 'float', '100', '300', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'kt_v_2', NULL, 'month_2_data', NULL, 70, NULL, NULL, 'text', 'Kt/V', NULL, NULL, 'float', '0.9', '3', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'drywt_2', NULL, 'month_2_data', NULL, 71, 'kilograms', NULL, 'text', 'Dry weight (kilograms)', NULL, NULL, 'float', '35', '200', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'no_show_2', NULL, 'month_2_data', NULL, 72, NULL, NULL, 'text', 'Number of treatments missed', NULL, NULL, 'float', '0', '7', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'compliance_2', NULL, 'month_2_data', NULL, 73, NULL, NULL, 'select', 'How compliant was the patient in drinking the supplement?', '0, 100 percent \\n 1, 99-75 percent \\n 2, 74-50 percent \\n 3, 49-25 percent \\n 4, 0-24 percent', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'hospit_2', NULL, 'month_2_data', NULL, 74, NULL, 'Hospitalization Data', 'select', 'Was patient hospitalized since last visit?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'cause_hosp_2', NULL, 'month_2_data', NULL, 75, NULL, NULL, 'select', 'What was the cause of hospitalization?', '1, Vascular access related events \\n 2, CVD events \\n 3, Other', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'admission_date_2', NULL, 'month_2_data', NULL, 76, NULL, NULL, 'text', 'Date of hospital admission', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'discharge_date_2', NULL, 'month_2_data', NULL, 77, NULL, NULL, 'text', 'Date of hospital discharge', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'discharge_summary_2', NULL, 'month_2_data', NULL, 78, NULL, NULL, 'select', 'Discharge summary in patients binder?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'death_2', NULL, 'month_2_data', NULL, 79, NULL, 'Mortality Data', 'select', 'Has patient died since last visit?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'date_death_2', NULL, 'month_2_data', NULL, 80, NULL, NULL, 'text', 'Date of death', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'cause_death_2', NULL, 'month_2_data', NULL, 81, NULL, NULL, 'select', 'What was the cause of death?', '1, All-cause \\n 2, Cardiovascular', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'month_2_data_complete', NULL, 'month_2_data', NULL, 82, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'date_visit_3', NULL, 'month_3_data', 'Month 3 Data', 83, NULL, 'Month 3', 'text', 'Date of Month 3 visit', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'date_blood_3', NULL, 'month_3_data', NULL, 84, NULL, NULL, 'text', 'Date blood was drawn', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'alb_3', NULL, 'month_3_data', NULL, 85, 'g/dL', NULL, 'text', 'Serum Albumin (g/dL)', NULL, NULL, 'float', '3', '5', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'prealb_3', NULL, 'month_3_data', NULL, 86, 'mg/dL', NULL, 'text', 'Serum Prealbumin (mg/dL)', NULL, NULL, 'float', '10', '40', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'creat_3', NULL, 'month_3_data', NULL, 87, 'mg/dL', NULL, 'text', 'Creatinine (mg/dL)', NULL, NULL, 'float', '0.5', '20', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'npcr_3', NULL, 'month_3_data', NULL, 88, 'g/kg/d', NULL, 'text', 'Normalized Protein Catabolic Rate (g/kg/d)', NULL, NULL, 'float', '0.5', '2', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'chol_3', NULL, 'month_3_data', NULL, 89, 'mg/dL', NULL, 'text', 'Cholesterol (mg/dL)', NULL, NULL, 'float', '100', '300', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'transferrin_3', NULL, 'month_3_data', NULL, 90, 'mg/dL', NULL, 'text', 'Transferrin (mg/dL)', NULL, NULL, 'float', '100', '300', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'kt_v_3', NULL, 'month_3_data', NULL, 91, NULL, NULL, 'text', 'Kt/V', NULL, NULL, 'float', '0.9', '3', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'drywt_3', NULL, 'month_3_data', NULL, 92, 'kilograms', NULL, 'text', 'Dry weight (kilograms)', NULL, NULL, 'float', '35', '200', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'plasma1_3', NULL, 'month_3_data', NULL, 93, NULL, NULL, 'select', 'Collected Plasma 1?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'plasma2_3', NULL, 'month_3_data', NULL, 94, NULL, NULL, 'select', 'Collected Plasma 2?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'plasma3_3', NULL, 'month_3_data', NULL, 95, NULL, NULL, 'select', 'Collected Plasma 3?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'serum1_3', NULL, 'month_3_data', NULL, 96, NULL, NULL, 'select', 'Collected Serum 1?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'serum2_3', NULL, 'month_3_data', NULL, 97, NULL, NULL, 'select', 'Collected Serum 2?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'serum3_3', NULL, 'month_3_data', NULL, 98, NULL, NULL, 'select', 'Collected Serum 3?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'sga_3', NULL, 'month_3_data', NULL, 99, NULL, NULL, 'text', 'Subject Global Assessment (score = 1-7)', NULL, NULL, 'float', '0.9', '7.1', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'no_show_3', NULL, 'month_3_data', NULL, 100, NULL, NULL, 'text', 'Number of treatments missed', NULL, NULL, 'float', '0', '7', 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'compliance_3', NULL, 'month_3_data', NULL, 101, NULL, NULL, 'select', 'How compliant was the patient in drinking the supplement?', '0, 100 percent \\n 1, 99-75 percent \\n 2, 74-50 percent \\n 3, 49-25 percent \\n 4, 0-24 percent', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'hospit_3', NULL, 'month_3_data', NULL, 102, NULL, 'Hospitalization Data', 'select', 'Was patient hospitalized since last visit?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'cause_hosp_3', NULL, 'month_3_data', NULL, 103, NULL, NULL, 'select', 'What was the cause of hospitalization?', '1, Vascular access related events \\n 2, CVD events \\n 3, Other', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'admission_date_3', NULL, 'month_3_data', NULL, 104, NULL, NULL, 'text', 'Date of hospital admission', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'discharge_date_3', NULL, 'month_3_data', NULL, 105, NULL, NULL, 'text', 'Date of hospital discharge', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'discharge_summary_3', NULL, 'month_3_data', NULL, 106, NULL, NULL, 'select', 'Discharge summary in patients binder?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'death_3', NULL, 'month_3_data', NULL, 107, NULL, 'Mortality Data', 'select', 'Has patient died since last visit?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'date_death_3', NULL, 'month_3_data', NULL, 108, NULL, NULL, 'text', 'Date of death', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'cause_death_3', NULL, 'month_3_data', NULL, 109, NULL, NULL, 'select', 'What was the cause of death?', '1, All-cause \\n 2, Cardiovascular', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'month_3_data_complete', NULL, 'month_3_data', NULL, 110, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'complete_study', NULL, 'completion_data', 'Completion Data', 111, NULL, 'Study Completion Information', 'select', 'Has patient completed study?', '0, No \\n 1, Yes', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'withdraw_date', NULL, 'completion_data', NULL, 112, NULL, NULL, 'text', 'Put a date if patient withdrew study', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'withdraw_reason', NULL, 'completion_data', NULL, 113, NULL, NULL, 'select', 'Reason patient withdrew from study', '0, Non-compliance \\n 1, Did not wish to continue in study \\n 2, Could not tolerate the supplement \\n 3, Hospitalization \\n 4, Other', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'complete_study_date', NULL, 'completion_data', NULL, 114, NULL, NULL, 'text', 'Date of study completion', NULL, NULL, 'date_ymd', NULL, NULL, 'soft_typed', NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'study_comments', NULL, 'completion_data', NULL, 115, NULL, 'General Comments', 'textarea', 'Comments', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL),
(@project_id, 'completion_data_complete', NULL, 'completion_data', NULL, 116, NULL, 'Form Status', 'select', 'Complete?', '0, Incomplete \\n 1, Unverified \\n 2, Complete', NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, NULL, NULL);

INSERT INTO `redcap_projects_templates` (`project_id`, `title`, `description`, `enabled`)
	VALUES (@project_id,  @project_title,  'Seven data entry forms for collecting data for a randomized clinical trial. Includes a short demographics form followed by a form where randomization is performed. An example randomization model has already been set up, although randomization allocation tables have not yet been created.',  '1');

-- Since project is in development, go ahead and pre-check items on Project Setup
INSERT INTO redcap_project_checklist (project_id, `name`) VALUES
(@project_id, 'design'),
(@project_id, 'modify_project'),
(@project_id, 'modules');